/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.SerializableMetadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.CmdLineMetExtractor;
import org.apache.oodt.cas.metadata.extractors.MetReaderConfig;
import org.apache.oodt.cas.metadata.extractors.MetReaderConfigReader;

public class MetReaderExtractor
extends CmdLineMetExtractor {
    private String metFileExt;
    public static final String DEFAULT_MET_FILE_EXT = "met";
    protected static MetReaderConfigReader reader = new MetReaderConfigReader();

    public MetReaderExtractor() {
        this(DEFAULT_MET_FILE_EXT);
    }

    public MetReaderExtractor(String metFileExt) {
        super(reader);
        this.metFileExt = metFileExt;
    }

    @Override
    public Metadata extrMetadata(File file) throws MetExtractionException {
        String extension = this.metFileExt;
        if (this.config != null) {
            extension = ((MetReaderConfig)this.config).getProperty("org.apache.oodt.cas.metadata.extractors.MetReader.metFileExt", this.metFileExt);
        }
        String metFileFullPath = file.getAbsolutePath() + "." + extension;
        LOG.log(Level.INFO, "Reading metadata from " + metFileFullPath);
        if (!new File(metFileFullPath).exists()) {
            throw new MetExtractionException("Met file: [" + metFileFullPath + "] does not exist: failing!");
        }
        try {
            SerializableMetadata met = new SerializableMetadata("UTF-8", false);
            met.loadMetadataFromXmlStream(new FileInputStream(metFileFullPath));
            return met;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetExtractionException(e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        MetReaderExtractor.processMain(args, new MetReaderExtractor());
    }
}

