/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.CmdLineMetExtractor;
import org.apache.oodt.cas.metadata.extractors.MetReaderConfig;
import org.apache.oodt.cas.metadata.extractors.MetReaderConfigReader;
import org.apache.tika.Tika;

public class TikaCmdLineMetExtractor
extends CmdLineMetExtractor {
    private static final Logger LOG = Logger.getLogger(TikaCmdLineMetExtractor.class.getName());
    protected static MetReaderConfigReader reader = new MetReaderConfigReader();

    public TikaCmdLineMetExtractor() {
        super(reader);
    }

    @Override
    public Metadata extrMetadata(File file) throws MetExtractionException {
        try {
            org.apache.tika.metadata.Metadata tikaMet = new org.apache.tika.metadata.Metadata();
            Metadata met = new Metadata();
            FileInputStream is = new FileInputStream(file);
            LOG.fine("Invoking tika extractor on file [" + file.getAbsolutePath() + "]");
            Tika tika = new Tika();
            tika.parse((InputStream)is, tikaMet);
            tikaMet.add("content", tika.parseToString(file));
            LOG.fine("Number of captured tika metadata keys: [" + tikaMet.names().length + "]");
            for (String key : tikaMet.names()) {
                met.addMetadata(key, tikaMet.get(key));
                LOG.fine("Added tika met key [" + key + "] with value [" + met.getMetadata(key) + "]");
            }
            MetReaderConfig myConfig = (MetReaderConfig)this.config;
            Enumeration<Object> configMetKeys = myConfig.keys();
            while (configMetKeys.hasMoreElements()) {
                String configMetKey = (String)configMetKeys.nextElement();
                String configMetKeyVal = (String)myConfig.get(configMetKey);
                met.addMetadata(configMetKey, configMetKeyVal);
                LOG.fine("Added config file met key [" + configMetKey + "] with value [" + met.getMetadata(configMetKeyVal) + "]");
            }
            return met;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.severe(e.getMessage());
            throw new MetExtractionException(e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        TikaCmdLineMetExtractor.processMain(args, new TikaCmdLineMetExtractor());
    }
}

