/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.filenaming;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.NamingConventionException;
import org.apache.oodt.cas.metadata.filenaming.NamingConvention;
import org.apache.oodt.cas.metadata.util.PathUtils;

public class PathUtilsNamingConvention
implements NamingConvention {
    private String namingConv;
    private Metadata tmpReplaceMet = new Metadata();

    @Override
    public File rename(File file, Metadata metadata) throws NamingConventionException {
        try {
            Validate.notNull((Object)file, (String)"Must specify file");
            Validate.notNull((Object)metadata, (String)"Must specify metadata");
            File newFile = new File(file.getParentFile(), PathUtils.doDynamicReplacement(this.namingConv, metadata));
            if (!file.renameTo(newFile)) {
                throw new IOException("Renaming file [" + file + "] to [" + newFile + "] returned false");
            }
            return newFile;
        }
        catch (Exception e) {
            throw new NamingConventionException("Failed to renaming file [" + file + "] : " + e.getMessage(), e);
        }
    }

    public void setNamingConv(String namingConv) {
        this.namingConv = namingConv;
    }

    public void addTmpReplaceMet(String key, List<String> values) {
        this.tmpReplaceMet.replaceMetadata(key, values);
    }

    public Metadata getTmpReplaceMet() {
        return this.tmpReplaceMet;
    }
}

