/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.cas.metadata.MetExtractor;

public final class GenericMetadataObjectFactory {
    private static final Logger LOG = Logger.getLogger(GenericMetadataObjectFactory.class.getName());

    public static MetExtractor getMetExtractorFromClassName(String className) {
        Class<?> metExtractorClass = null;
        MetExtractor extractor = null;
        try {
            metExtractorClass = Class.forName(className);
            extractor = (MetExtractor)metExtractorClass.newInstance();
            return extractor;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "ClassNotFoundException when loading met extractor class " + className + " Message: " + e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "InstantiationException when loading met extractor class " + className + " Message: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "IllegalAccessException when loading met extractor class " + className + " Message: " + e.getMessage());
        }
        return null;
    }
}

