/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Metadata {
    private Group root = this.createNewRoot();

    public Metadata() {
    }

    public Metadata(Metadata metadata) {
        this();
        this.addMetadata(metadata);
    }

    public void addMetadata(Metadata metadata) {
        for (String key : metadata.getAllKeys()) {
            this.addMetadata(key, metadata.getAllMetadata(key));
        }
    }

    public void addMetadata(String group, Metadata metadata) {
        if (group == null) {
            this.addMetadata(metadata);
        } else {
            for (String key : metadata.getAllKeys()) {
                this.addMetadata(group + "/" + key, metadata.getAllMetadata(key));
            }
        }
    }

    public void replaceMetadata(Metadata metadata) {
        for (String key : metadata.getAllKeys()) {
            this.replaceMetadata(key, metadata.getAllMetadata(key));
        }
    }

    public void replaceMetadata(String group, Metadata metadata) {
        if (group == null) {
            this.replaceMetadata(metadata);
        } else {
            for (String key : metadata.getAllKeys()) {
                this.replaceMetadata(group + "/" + key, metadata.getAllMetadata(key));
            }
        }
    }

    public void addMetadata(String key, String value) {
        this.getGroup(key).addValue(value);
    }

    public void replaceMetadata(String key, String value) {
        this.getGroup(key).setValue(value);
    }

    public void addMetadata(String key, List<String> values) {
        this.getGroup(key).addValues(values);
    }

    public void replaceMetadata(String key, List<String> values) {
        this.getGroup(key).setValues(values);
    }

    public void removeMetadata(String key) {
        Group removeGroup = this.getGroup(key, false);
        if (removeGroup != null && removeGroup.hasValues()) {
            if (removeGroup.getChildren().size() > 0) {
                removeGroup.clearValues();
            } else {
                removeGroup.getParent().removeChild(removeGroup.getName());
            }
        }
    }

    public void removeMetadataGroup(String group) {
        Group removeGroup = this.getGroup(group, false);
        if (removeGroup != null && removeGroup.getChildren().size() > 0) {
            removeGroup.getParent().removeChild(removeGroup.getName());
        }
    }

    public boolean containsKey(String key) {
        Group group = this.getGroup(key, false);
        return group != null && group.hasValues();
    }

    public boolean isMultiValued(String key) {
        Group group = this.getGroup(key, false);
        return group != null && group.getValues().size() > 1;
    }

    public Metadata getSubMetadata(String group) {
        Metadata m = new Metadata();
        Group newRoot = this.getGroup(group, false);
        if (newRoot != null) {
            m.root.addChildren(newRoot.clone().getChildren());
        }
        return m;
    }

    public String getMetadata(String key) {
        Group group = this.getGroup(key, false);
        if (group != null) {
            return group.getValue();
        }
        return null;
    }

    public List<String> getAllMetadata(String key) {
        Group group = this.getGroup(key, false);
        if (group != null) {
            return new Vector<String>(group.getValues());
        }
        return null;
    }

    public List<String> getKeys(String group) {
        Group foundGroup = this.getGroup(group);
        if (foundGroup != null) {
            return this.getKeys(foundGroup);
        }
        return new Vector<String>();
    }

    public List<String> getKeys() {
        return this.getKeys(this.root);
    }

    protected List<String> getKeys(Group group) {
        Vector<String> keys = new Vector<String>();
        for (Group child : group.getChildren()) {
            if (!child.hasValues()) continue;
            keys.add(child.getFullPath());
        }
        return keys;
    }

    public List<String> getAllKeys(String group) {
        Group foundGroup = this.getGroup(group);
        if (foundGroup != null) {
            return this.getAllKeys(foundGroup);
        }
        return new Vector<String>();
    }

    public List<String> getAllKeys() {
        return this.getAllKeys(this.root);
    }

    protected List<String> getAllKeys(Group group) {
        Vector<String> keys = new Vector<String>();
        for (Group child : group.getChildren()) {
            if (child.hasValues()) {
                keys.add(child.getFullPath());
            }
            keys.addAll(this.getAllKeys(child));
        }
        return keys;
    }

    public List<String> getAllKeysWithName(String key) {
        Vector<String> keys = new Vector<String>();
        Stack<Group> stack = new Stack<Group>();
        stack.add(this.root);
        while (!stack.empty()) {
            Group curGroup = (Group)stack.pop();
            if (curGroup.getName().equals(key) && curGroup.hasValues()) {
                keys.add(curGroup.getFullPath());
            }
            stack.addAll(curGroup.getChildren());
        }
        return keys;
    }

    public List<String> getValues() {
        Vector<String> values = new Vector<String>();
        for (String key : this.getKeys()) {
            values.addAll(this.getAllMetadata(key));
        }
        return values;
    }

    public List<String> getValues(String group) {
        Vector<String> values = new Vector<String>();
        for (String key : this.getKeys(group)) {
            values.addAll(this.getAllMetadata(key));
        }
        return values;
    }

    public List<String> getAllValues() {
        Vector<String> values = new Vector<String>();
        for (String key : this.getAllKeys()) {
            values.addAll(this.getAllMetadata(key));
        }
        return values;
    }

    public List<String> getAllValues(String group) {
        Vector<String> values = new Vector<String>();
        for (String key : this.getAllKeys(group)) {
            values.addAll(this.getAllMetadata(key));
        }
        return values;
    }

    public void addMetadata(Hashtable<String, Object> metadata) {
        this.addMetadata(metadata, false);
    }

    public void addMetadata(Hashtable<String, Object> metadata, boolean replace) {
        for (String key : metadata.keySet()) {
            List<String> vals;
            List<String> list = vals = metadata.get(key) instanceof List ? (List<String>)metadata.get(key) : Collections.singletonList(metadata.get(key).toString());
            if (replace) {
                this.replaceMetadata(key, vals);
                continue;
            }
            this.addMetadata(key, vals);
        }
    }

    public void replaceMetadata(Hashtable<String, Object> metadata) {
        this.root = this.createNewRoot();
        this.addMetadata(metadata);
    }

    public boolean containsGroup(String group) {
        return this.getGroup(group, false) != null;
    }

    public List<String> getGroups() {
        return this.getGroups(this.root);
    }

    public List<String> getGroups(String group) {
        return this.getGroups(this.getGroup(group));
    }

    protected List<String> getGroups(Group group) {
        Vector<String> groupNames = new Vector<String>();
        for (Group child : group.getChildren()) {
            groupNames.add(child.getName());
        }
        return groupNames;
    }

    protected Group getGroup(String key) {
        return this.getGroup(key, true);
    }

    protected Group getGroup(String key, boolean create) {
        if (key == null) {
            return this.root;
        }
        StringTokenizer tokenizer = new StringTokenizer(key, "/");
        Group curGroup = this.root;
        while (tokenizer.hasMoreTokens()) {
            String groupName = tokenizer.nextToken();
            Group childGroup = curGroup.getChild(groupName);
            if (childGroup == null) {
                if (!create) {
                    return null;
                }
                childGroup = new Group(groupName);
                curGroup.addChild(childGroup);
            }
            curGroup = childGroup;
        }
        return curGroup;
    }

    protected Group createNewRoot() {
        return new Group("root");
    }

    public Hashtable<String, Object> getHashtable() {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        for (String key : this.getAllKeys()) {
            table.put(key, this.getAllMetadata(key));
        }
        return table;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Metadata) {
            Metadata compMet = (Metadata)obj;
            if (((Object)this.getKeys()).equals(compMet.getKeys())) {
                for (String key : this.getKeys()) {
                    if (((Object)this.getAllMetadata(key)).equals(compMet.getAllMetadata(key))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected class Group {
        private static final String ROOT_GROUP_NAME = "root";
        private String name;
        private List<String> values;
        private Group parent;
        private Map<String, Group> children;

        public Group(String name) {
            this.name = name;
            this.values = new Vector<String>();
            this.children = new HashMap<String, Group>();
        }

        public String getName() {
            return this.name;
        }

        public String getFullPath() {
            if (this.parent != null && !this.parent.getName().equals(ROOT_GROUP_NAME)) {
                return this.parent.getFullPath() + "/" + this.name;
            }
            return this.name;
        }

        public Group getParent() {
            return this.parent;
        }

        public void setValue(String value) {
            this.values.clear();
            this.values.add(value);
        }

        public void setValues(List<String> values) {
            this.values.clear();
            this.values.addAll(values);
        }

        public void clearValues() {
            this.values.clear();
        }

        public void addValue(String value) {
            this.values.add(value);
        }

        public void addValues(List<String> value) {
            this.values.addAll(value);
        }

        public boolean hasValues() {
            return this.values.size() > 0;
        }

        public String getValue() {
            if (this.hasValues()) {
                return this.values.get(0);
            }
            return null;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void addChild(Group child) {
            this.children.put(child.getName(), child);
            child.parent = this;
        }

        public void addChildren(List<Group> children) {
            for (Group child : children) {
                this.addChild(child);
            }
        }

        public List<Group> getChildren() {
            return new Vector<Group>(this.children.values());
        }

        public void removeChild(String name) {
            this.children.remove(name);
        }

        public Group getChild(String name) {
            return this.children.get(name);
        }

        public Group clone() {
            Group clone = new Group(this.name);
            clone.setValues(this.values);
            for (Group child : this.children.values()) {
                clone.addChild(child.clone());
            }
            return clone;
        }

        public String toString() {
            return this.getFullPath();
        }
    }
}

