/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.DataSourceMetExtractor;

public class ParentKeyDataSourceMetExtractor
extends DataSourceMetExtractor {
    private String key;

    @Override
    protected Metadata extrMetadata(File file) throws MetExtractionException {
        try {
            this.key = this.getPrimaryKey(file);
            return super.extrMetadata(file);
        }
        catch (MetExtractionException e) {
            this.key = this.getParentKey(file);
            if (this.key != null) {
                return super.extrMetadata(file);
            }
            throw e;
        }
    }

    @Override
    @VisibleForTesting
    protected String getKey(File file) {
        return this.key;
    }

    private String getPrimaryKey(File file) {
        String key = this.getKeyAtIndex(file, Index.PRIMARY);
        return key == null ? super.getKey(file) : key;
    }

    private String getParentKey(File file) {
        return this.getKeyAtIndex(file, Index.PARENT);
    }

    private String getKeyAtIndex(File file, Index index) {
        String key = super.getKey(file);
        ArrayList splitKey = Lists.newArrayList((Iterable)Splitter.on((String)"_").split((CharSequence)key));
        if (splitKey.size() == 2) {
            return (String)splitKey.get(index.getNumeric());
        }
        return null;
    }

    private static enum Index {
        PRIMARY(1),
        PARENT(0);

        private int index;

        private Index(int index) {
            this.index = index;
        }

        public int getNumeric() {
            return this.index;
        }
    }
}

