/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.io.File;
import java.io.FileFilter;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.product.ProductException;
import org.apache.oodt.product.handlers.ofsn.OFSNListHandler;

public abstract class AbstractCrawlLister
implements OFSNListHandler {
    protected static final Logger LOG = Logger.getLogger(AbstractCrawlLister.class.getName());
    protected static final FileFilter FILE_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    };
    protected static final FileFilter DIR_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public abstract void configure(Properties var1);

    public abstract File[] getListing(String var1) throws ProductException;

    protected File[] crawlFiles(File dirRoot, boolean recur, boolean crawlForDirs) {
        if (dirRoot == null || dirRoot != null && !dirRoot.exists()) {
            throw new IllegalArgumentException("dir root: [" + dirRoot + "] is null or non existant!");
        }
        Vector<File> fileList = new Vector<File>();
        Stack<File> stack = new Stack<File>();
        stack.push(dirRoot.isDirectory() ? dirRoot : dirRoot.getParentFile());
        while (!stack.isEmpty()) {
            File[] subdirs;
            File dir = (File)stack.pop();
            LOG.log(Level.INFO, "OFSN: Crawling " + dir);
            File[] productFiles = null;
            productFiles = crawlForDirs ? dir.listFiles(DIR_FILTER) : dir.listFiles(FILE_FILTER);
            for (int j = 0; j < productFiles.length; ++j) {
                fileList.add(productFiles[j]);
            }
            if (!recur || (subdirs = dir.listFiles(DIR_FILTER)) == null) continue;
            for (int j = 0; j < subdirs.length; ++j) {
                stack.push(subdirs[j]);
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }
}

