/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.oodt.product.ProductException;
import org.apache.oodt.product.handlers.ofsn.OFSNGetHandler;

public class StdOFSNGetHandler
implements OFSNGetHandler {
    @Override
    public byte[] retrieveChunk(String filepath, long offset, int length) throws ProductException {
        InputStream in = null;
        byte[] buf = null;
        try {
            in = new FileInputStream(new File(filepath));
            buf = new byte[length];
            long numSkipped = in.skip(offset);
            if (numSkipped != offset) {
                throw new ProductException("Was not able to skip: [" + offset + "] bytes into product: num actually skipped: [" + numSkipped + "]");
            }
            int numRead = in.read(buf, 0, length);
            if (numRead != length) {
                throw new ProductException("Was not able to read: [" + length + "] bytes from product: num actually read: [" + numRead + "]");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ProductException("IO exception retrieving chunk of product: [" + filepath + "]: Message: " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignore) {}
                in = null;
            }
        }
        return buf;
    }

    @Override
    public long sizeOf(String filepath) {
        return new File(filepath).length();
    }

    @Override
    public void configure(Properties conf) {
    }
}

