/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.xmlquery;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.oodt.xmlquery.ChunkedProductInputStream;
import org.apache.oodt.xmlquery.Result;

public class LargeResult
extends Result {
    private long size;
    static final long serialVersionUID = -969838775595705444L;

    public LargeResult(Result result) {
        super(result.getID(), "application/vnd.jpl.large-product", result.getProfileID(), result.getResourceID(), result.getHeaders(), (Object)LargeResult.transformMimeType(result));
        StringTokenizer st = new StringTokenizer((String)this.value);
        st.nextToken();
        this.size = Long.parseLong(st.nextToken());
    }

    public LargeResult(String id, String mimeType, String profileID, String resourceID, List headers, long size) {
        super(id, "application/vnd.jpl.large-product", profileID, resourceID, headers, (Object)(mimeType + " " + size));
        this.size = size;
    }

    public final long getSize() {
        return this.size;
    }

    public final String getMimeType() {
        return new StringTokenizer((String)this.value).nextToken();
    }

    public final Object getValue() {
        String value = null;
        InputStream in = null;
        try {
            int num;
            if (this.size > Integer.MAX_VALUE) {
                throw new IllegalStateException("Cannot use getValue() for this product, result is too large; use LargeResult.getInputStream instead");
            }
            int sizeToRead = (int)this.size;
            byte[] buf = new byte[sizeToRead];
            int index = 0;
            in = this.getInputStream();
            while ((num = in.read(buf, index, sizeToRead)) != -1) {
                index += num;
                if ((sizeToRead -= num) != 0) continue;
            }
            value = new String(buf);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected IOException: " + ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return value;
    }

    public InputStream getInputStream() throws IOException {
        return new ChunkedProductInputStream(this.id, this.retriever, this.size);
    }

    private static String transformMimeType(Result result) {
        if ("application/vnd.jpl.large-product".equals(result.mimeType)) {
            return (String)result.value;
        }
        return result.mimeType + " 0";
    }
}

