/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers.lightweight;

import java.util.List;
import org.apache.oodt.profile.RangedProfileElement;
import org.apache.oodt.profile.handlers.lightweight.FalseResult;
import org.apache.oodt.profile.handlers.lightweight.MatchingResult;
import org.apache.oodt.profile.handlers.lightweight.Result;
import org.apache.oodt.profile.handlers.lightweight.SearchableProfile;
import org.apache.oodt.profile.handlers.lightweight.SearchableProfileElement;

public class SearchableRangedProfileElement
extends RangedProfileElement
implements SearchableProfileElement {
    public SearchableRangedProfileElement(SearchableProfile profile, String name, String id, String desc, String type, String unit, List synonyms, boolean obligation, int maxOccurrence, String comment, String min, String max) {
        super(profile, name, id, desc, type, unit, synonyms, obligation, maxOccurrence, comment, min, max);
    }

    @Override
    public Result result(String value, String operator) {
        Result rc = FalseResult.INSTANCE;
        double numeric = Double.parseDouble(value);
        if (operator.equals("EQ") || operator.equals("LIKE")) {
            if (Double.parseDouble(this.min) <= numeric && numeric <= Double.parseDouble(this.max)) {
                rc = new MatchingResult(this);
            }
        } else if (operator.equals("NE") || operator.equals("NOTLIKE")) {
            if (numeric < Double.parseDouble(this.min) || numeric > Double.parseDouble(this.max)) {
                rc = new MatchingResult(this);
            }
        } else if (operator.equals("LT")) {
            if (numeric > Double.parseDouble(this.min)) {
                rc = new MatchingResult(this);
            }
        } else if (operator.equals("GT")) {
            if (numeric < Double.parseDouble(this.max)) {
                rc = new MatchingResult(this);
            }
        } else if (operator.equals("LE")) {
            if (numeric >= Double.parseDouble(this.min)) {
                rc = new MatchingResult(this);
            }
        } else if (numeric <= Double.parseDouble(this.max)) {
            rc = new MatchingResult(this);
        }
        return rc;
    }
}

