/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.oodt.profile.EnumeratedProfileElement;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.gui.profileTree;

public class LeafListener
extends MouseAdapter {
    profileTree tree;

    public LeafListener(profileTree jtr) {
        this.tree = jtr;
    }

    private boolean isValidMultiTerm(String t) {
        if (t == null) {
            return false;
        }
        if (t.equals("Children")) {
            return true;
        }
        if (t.equals("Revision Notes")) {
            return true;
        }
        if (t.equals("Contexts")) {
            return true;
        }
        if (t.equals("Contributors")) {
            return true;
        }
        if (t.equals("Coverages")) {
            return true;
        }
        if (t.equals("Creators")) {
            return true;
        }
        if (t.equals("Dates")) {
            return true;
        }
        if (t.equals("Formats")) {
            return true;
        }
        if (t.equals("Languages")) {
            return true;
        }
        if (t.equals("Resource Locations")) {
            return true;
        }
        if (t.equals("Publishers")) {
            return true;
        }
        if (t.equals("Relations")) {
            return true;
        }
        if (t.equals("Rights")) {
            return true;
        }
        if (t.equals("Sources")) {
            return true;
        }
        if (t.equals("Subjects")) {
            return true;
        }
        if (t.equals("Types")) {
            return true;
        }
        if (t.equals("Profile Elements")) {
            return true;
        }
        return t.equals("Synonyms");
    }

    public DefaultMutableTreeNode generateNewProfileElementTree(String peName) {
        DefaultMutableTreeNode peRoot = null;
        EnumeratedProfileElement theProfileElement = new EnumeratedProfileElement(new Profile());
        peRoot = new DefaultMutableTreeNode(peName);
        DefaultMutableTreeNode theCommentsRoot = new DefaultMutableTreeNode("Comments");
        DefaultMutableTreeNode theComments = new DefaultMutableTreeNode(theProfileElement.getComments());
        theCommentsRoot.add(theComments);
        DefaultMutableTreeNode theDesc = new DefaultMutableTreeNode(theProfileElement.getDescription());
        DefaultMutableTreeNode theDescRoot = new DefaultMutableTreeNode("Description");
        theDescRoot.add(theDesc);
        DefaultMutableTreeNode theID = new DefaultMutableTreeNode(theProfileElement.getID());
        DefaultMutableTreeNode theIDRoot = new DefaultMutableTreeNode("ID");
        theIDRoot.add(theID);
        DefaultMutableTreeNode theMO = new DefaultMutableTreeNode(new Integer(theProfileElement.getMaxOccurrence()).toString());
        DefaultMutableTreeNode theMORoot = new DefaultMutableTreeNode("Max Occurence");
        theMORoot.add(theMO);
        DefaultMutableTreeNode theSynonyms = new DefaultMutableTreeNode("Synonyms");
        for (String theSynonym : theProfileElement.getSynonyms()) {
            DefaultMutableTreeNode sNode = new DefaultMutableTreeNode(theSynonym);
            theSynonyms.add(sNode);
        }
        DefaultMutableTreeNode theType = new DefaultMutableTreeNode(theProfileElement.getType());
        DefaultMutableTreeNode theTypeRoot = new DefaultMutableTreeNode("Type");
        theTypeRoot.add(theType);
        DefaultMutableTreeNode theUnit = new DefaultMutableTreeNode(theProfileElement.getUnit());
        DefaultMutableTreeNode theUnitRoot = new DefaultMutableTreeNode("Unit");
        theUnitRoot.add(theUnit);
        peRoot.add(theCommentsRoot);
        peRoot.add(theDescRoot);
        peRoot.add(theIDRoot);
        peRoot.add(theMORoot);
        peRoot.add(theSynonyms);
        peRoot.add(theTypeRoot);
        peRoot.add(theUnitRoot);
        return peRoot;
    }

    protected void menuItem2ActionPerformed(ActionEvent evt, DefaultMutableTreeNode theTreeNode, DefaultTreeModel theModel) {
        String treeNodeName = (String)theTreeNode.getUserObject();
        if (this.isValidMultiTerm(treeNodeName)) {
            return;
        }
        String newNodeName = (String)JOptionPane.showInputDialog(null, "Edit", "Enter New Node Value", -1, null, null, "New Value");
        if (newNodeName == null) {
            return;
        }
        theTreeNode.setUserObject(newNodeName);
        theModel.reload();
    }

    protected void menuItem1ActionPerformed(ActionEvent evt, DefaultMutableTreeNode theTreeNode, DefaultTreeModel theModel) {
        String treeNodeName = (String)theTreeNode.getUserObject();
        if (!this.isValidMultiTerm(treeNodeName)) {
            return;
        }
        DefaultMutableTreeNode theAddNode = null;
        String childNodeName = (String)JOptionPane.showInputDialog(null, "Add", "Enter Node Name", -1, null, null, "Child Value");
        if (childNodeName == null) {
            return;
        }
        theAddNode = treeNodeName.equals("Profile Elements") ? this.generateNewProfileElementTree(childNodeName) : new DefaultMutableTreeNode(childNodeName);
        theTreeNode.add(theAddNode);
        theModel.reload();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int selectedRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selectedPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selectedRow != -1) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
            JMenuItem menuItem1 = new JMenuItem("Add");
            JMenuItem menuItem2 = new JMenuItem("Edit");
            menuItem2.addActionListener(new TreeNodeActionListener(tn, this, (DefaultTreeModel)this.tree.getModel(), "EDIT"));
            menuItem1.addActionListener(new TreeNodeActionListener(tn, this, (DefaultTreeModel)this.tree.getModel(), "ADD"));
            JPopupMenu popup = new JPopupMenu();
            popup.add(menuItem1);
            popup.add(menuItem2);
            if (e.isPopupTrigger()) {
                popup.show(this.tree, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int selectedRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selectedPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selectedRow != -1) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
            JMenuItem menuItem1 = new JMenuItem("Add");
            JMenuItem menuItem2 = new JMenuItem("Edit");
            menuItem2.addActionListener(new TreeNodeActionListener(tn, this, (DefaultTreeModel)this.tree.getModel(), "EDIT"));
            menuItem1.addActionListener(new TreeNodeActionListener(tn, this, (DefaultTreeModel)this.tree.getModel(), "ADD"));
            JPopupMenu popup = new JPopupMenu();
            popup.add(menuItem1);
            popup.add(menuItem2);
            if (e.isPopupTrigger()) {
                popup.show(this.tree, e.getX(), e.getY());
            }
        }
    }

    public class TreeNodeActionListener
    implements ActionListener {
        private DefaultMutableTreeNode myTreeNode = null;
        private DefaultTreeModel myTreeModel = null;
        private LeafListener theLeafListener = null;
        private String type = null;

        public TreeNodeActionListener(DefaultMutableTreeNode t, LeafListener l, DefaultTreeModel tm, String theType) {
            this.myTreeNode = t;
            this.theLeafListener = l;
            this.myTreeModel = tm;
            this.type = theType;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.type.equals("ADD")) {
                this.theLeafListener.menuItem1ActionPerformed(evt, this.myTreeNode, this.myTreeModel);
            } else if (this.type.equals("EDIT")) {
                this.theLeafListener.menuItem2ActionPerformed(evt, this.myTreeNode, this.myTreeModel);
            }
        }
    }
}

