/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.pcs.input;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.oodt.pcs.input.PGEDataParseKeys;
import org.apache.oodt.pcs.input.PGEMatrix;
import org.apache.oodt.pcs.input.PGEScalar;
import org.apache.oodt.pcs.input.PGEVector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PGEDataHandler
extends DefaultHandler
implements PGEDataParseKeys {
    private static final Logger LOG = Logger.getLogger(PGEDataHandler.class.getName());
    private Map scalars = new HashMap();
    private Map vectors = new HashMap();
    private Map matrices = new HashMap();
    private int parseStatus = -1;
    private boolean vecElement = false;
    private boolean matrixElement = false;
    private PGEScalar currentScalar = null;
    private PGEVector currentVector = null;
    private PGEMatrix currentMatrix = null;
    private StringBuffer charBuf;
    private int currentRow = 0;
    private int currentCol = 0;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.notParsing()) {
            if (qName.equals("scalar")) {
                this.parseStatus = -20;
                this.currentScalar = new PGEScalar();
                this.currentScalar.setName(attributes.getValue("name"));
                this.charBuf = new StringBuffer();
            } else if (qName.equals("vector")) {
                this.parseStatus = -10;
                this.currentVector = new PGEVector();
                this.currentVector.setName(attributes.getValue("name"));
            } else if (qName.equals("matrix")) {
                this.parseStatus = -30;
                this.currentMatrix = new PGEMatrix(attributes.getValue("name"), Integer.parseInt(attributes.getValue("rows")), Integer.parseInt(attributes.getValue("cols")));
            }
        } else {
            if (this.isParsingScalar()) {
                throw new SAXException("Parsing scalar: [" + this.currentScalar.getName() + "]: Should not encounter another tag within");
            }
            if (this.isParsingVector()) {
                if (qName.equals("element")) {
                    this.vecElement = true;
                    this.charBuf = new StringBuffer();
                }
            } else if (this.isParsingMatrix() && qName.equals("td")) {
                this.matrixElement = true;
                this.charBuf = new StringBuffer();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("scalar")) {
            this.currentScalar.setValue(this.charBuf.toString());
            this.scalars.put(this.currentScalar.getName(), this.currentScalar);
            this.clearCharBuf();
            this.parseStatus = -1;
        } else if (qName.equals("element")) {
            this.currentVector.getElements().add(this.charBuf.toString());
            this.clearCharBuf();
            this.vecElement = false;
        } else if (qName.equals("vector")) {
            if (this.currentVector != null) {
                this.vectors.put(this.currentVector.getName(), this.currentVector);
                this.parseStatus = -1;
            }
        } else if (qName.equals("matrix")) {
            if (this.currentMatrix != null) {
                this.matrices.put(this.currentMatrix.getName(), this.currentMatrix);
                this.parseStatus = -1;
                this.currentCol = 0;
                this.currentRow = 0;
            }
        } else if (qName.equals("tr")) {
            ++this.currentRow;
            this.currentCol = 0;
        } else if (qName.equals("td")) {
            this.currentMatrix.addValue(this.charBuf.toString(), this.currentRow, this.currentCol);
            ++this.currentCol;
            this.clearCharBuf();
            this.matrixElement = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isParsingScalar() || this.isParsingVectorElement() || this.isParsingMatrixElement()) {
            this.charBuf.append(ch, start, length);
        }
    }

    public Map getMatrices() {
        return this.matrices;
    }

    public void setMatrices(Map matrices) {
        this.matrices = matrices;
    }

    public Map getScalars() {
        return this.scalars;
    }

    public void setScalars(Map scalars) {
        this.scalars = scalars;
    }

    public Map getVectors() {
        return this.vectors;
    }

    public void setVectors(Map vectors) {
        this.vectors = vectors;
    }

    public boolean isParsingScalar() {
        return this.parseStatus == -20;
    }

    public boolean isParsingVector() {
        return this.parseStatus == -10;
    }

    public boolean isParsingMatrix() {
        return this.parseStatus == -30;
    }

    public boolean isParsingMatrixElement() {
        return this.matrixElement;
    }

    public boolean isParsingVectorElement() {
        return this.vecElement;
    }

    public boolean notParsing() {
        return this.parseStatus == -1;
    }

    private void clearCharBuf() {
        this.charBuf.setLength(0);
        this.charBuf = null;
    }
}

