/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.pcs.input;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.oodt.commons.xml.XMLUtils;
import org.apache.oodt.pcs.input.PGEConfigFileKeys;
import org.apache.oodt.pcs.input.PGEConfigurationFile;
import org.apache.oodt.pcs.input.PGEDataParseKeys;
import org.apache.oodt.pcs.input.PGEGroup;
import org.apache.oodt.pcs.input.PGEMatrix;
import org.apache.oodt.pcs.input.PGEScalar;
import org.apache.oodt.pcs.input.PGEVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PGEConfigFileWriter
implements PGEConfigFileKeys,
PGEDataParseKeys {
    private PGEConfigurationFile configFile = null;
    private static Logger LOG = Logger.getLogger(PGEConfigFileWriter.class.getName());
    private boolean urlEncoding = false;
    private String schemaLocation = null;

    public PGEConfigFileWriter(PGEConfigurationFile config) {
        this.configFile = config;
    }

    public void writeToXmlFile(String filePath) throws Exception {
        XMLUtils.writeXmlFile((Document)this.getConfigFileXml(), (String)filePath);
    }

    public Document getConfigFileXml() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("input");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xsi:noNamespaceSchemaLocation", this.schemaLocation == null || this.schemaLocation != null && this.schemaLocation.equals("") ? "input.xsd" : this.schemaLocation);
            document.appendChild(root);
            if (this.configFile != null) {
                if (this.configFile.getPgeName() != null) {
                    PGEGroup pgeNameGroup = new PGEGroup("PGENameGroup");
                    pgeNameGroup.addScalar(this.configFile.getPgeName());
                    root.appendChild(this.getGroupElement(pgeNameGroup, document));
                }
                root.appendChild(this.getGroupElement(this.configFile.getInputProductFiles(), document));
                root.appendChild(this.getGroupElement(this.configFile.getStaticFileIdentificationFiles(), document));
                root.appendChild(this.getGroupElement(this.configFile.getDynamicAuxiliaryInputFiles(), document));
                root.appendChild(this.getGroupElement(this.configFile.getRecordedAuxiliaryInputFiles(), document));
                if (this.configFile.getProductPath() != null) {
                    PGEGroup productPathGroup = new PGEGroup("ProductPathGroup");
                    productPathGroup.addScalar(this.configFile.getProductPath());
                    root.appendChild(this.getGroupElement(productPathGroup, document));
                }
                root.appendChild(this.getGroupElement(this.configFile.getMonitorLevelGroup(), document));
                if (this.configFile.getMonitorFilenameFormat() != null && this.configFile.getMonitorPath() != null) {
                    PGEGroup monitorGroup = new PGEGroup("MonitorGroup");
                    monitorGroup.addScalar(this.configFile.getMonitorPath());
                    monitorGroup.addScalar(this.configFile.getMonitorFilenameFormat());
                    root.appendChild(this.getGroupElement(monitorGroup, document));
                }
                for (String pgeSpecificGroupName : this.configFile.getPgeSpecificGroups().keySet()) {
                    PGEGroup pgeSpecificGroup = this.configFile.getPgeSpecificGroups().get(pgeSpecificGroupName);
                    root.appendChild(this.getGroupElement(pgeSpecificGroup, document));
                }
            }
            return document;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            LOG.log(Level.WARNING, "Error generating pge configuration file!: " + pce.getMessage());
            throw new Exception("Error generating pge configuration file!: " + pce.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Element getGroupElement(PGEGroup group, Document document) throws Exception {
        Element groupElem = document.createElement("group");
        groupElem.setAttribute("name", group.getName());
        if (group.getNumScalars() > 0) {
            for (String scalarName : group.getScalars().keySet()) {
                PGEScalar scalar = group.getScalar(scalarName);
                Element scalarElem = document.createElement("scalar");
                scalarElem.setAttribute("name", scalar.getName());
                if (scalar.getValue() == null) {
                    throw new Exception("Attempt to write null value for scalar: [" + scalarName + "] to PGE config file!");
                }
                if (this.urlEncoding) {
                    try {
                        scalarElem.appendChild(document.createTextNode(URLEncoder.encode(scalar.getValue(), "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.log(Level.WARNING, "Error creating text node for scalar element: " + scalar.getName() + " in pge group: " + group.getName() + " Message: " + e.getMessage());
                    }
                } else {
                    scalarElem.appendChild(document.createTextNode(scalar.getValue()));
                }
                groupElem.appendChild(scalarElem);
            }
        }
        if (group.getNumVectors() > 0) {
            for (String vectorName : group.getVectors().keySet()) {
                PGEVector vector = group.getVector(vectorName);
                Element vectorElem = document.createElement("vector");
                vectorElem.setAttribute("name", vector.getName());
                for (String string : vector.getElements()) {
                    if (string == null) {
                        throw new Exception("Attempt to write null value for vector: [" + vectorName + "] to PGE config file!");
                    }
                    Element elementElem = document.createElement("element");
                    if (this.urlEncoding) {
                        try {
                            elementElem.appendChild(document.createTextNode(URLEncoder.encode(string, "UTF-8")));
                        }
                        catch (UnsupportedEncodingException e) {
                            LOG.log(Level.WARNING, "Error creating text node for vector element: " + vector.getName() + " in pge group: " + group.getName() + " Message: " + e.getMessage());
                        }
                    } else {
                        elementElem.appendChild(document.createTextNode(string));
                    }
                    vectorElem.appendChild(elementElem);
                }
                groupElem.appendChild(vectorElem);
            }
        }
        if (group.getNumMatrixs() > 0) {
            for (String matrixName : group.getMatrixs().keySet()) {
                PGEMatrix matrix = group.getMatrix(matrixName);
                Element matrixElem = document.createElement("matrix");
                matrixElem.setAttribute("name", matrix.getName());
                int rowNum = 0;
                for (List<Object> rowValues : matrix.getRows()) {
                    Element rowElem = document.createElement("tr");
                    int colNum = 0;
                    for (String string : rowValues) {
                        Element colElem = document.createElement("td");
                        if (string == null) {
                            throw new Exception("Attempt to write null value for matrix: [" + matrixName + "]: " + "(" + rowNum + "," + colNum + ")");
                        }
                        if (this.urlEncoding) {
                            try {
                                colElem.appendChild(document.createTextNode(URLEncoder.encode(string, "UTF-8")));
                            }
                            catch (UnsupportedEncodingException e) {
                                LOG.log(Level.WARNING, "Error creating node for matrix element: " + matrix.getName() + " (" + rowNum + "," + colNum + ") in pge group: " + group.getName() + " Message: " + e.getMessage());
                            }
                        } else {
                            colElem.appendChild(document.createTextNode(string));
                        }
                        ++colNum;
                    }
                    ++rowNum;
                }
                groupElem.appendChild(matrixElem);
            }
        }
        if (group.getNumGroups() > 0) {
            for (String groupName : group.getGroups().keySet()) {
                PGEGroup subgroup = group.getGroup(groupName);
                Element subgroupElem = this.getGroupElement(subgroup, document);
                groupElem.appendChild(subgroupElem);
            }
        }
        return groupElem;
    }

    public boolean isUrlEncoding() {
        return this.urlEncoding;
    }

    public void setUrlEncoding(boolean urlEncoding) {
        this.urlEncoding = urlEncoding;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }
}

