/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.pcs.input;

import java.util.HashMap;
import java.util.Map;
import org.apache.oodt.pcs.input.PGEMatrix;
import org.apache.oodt.pcs.input.PGEScalar;
import org.apache.oodt.pcs.input.PGEVector;

public class PGEGroup {
    private String name = null;
    private Map<String, PGEScalar> scalars = null;
    private Map<String, PGEVector> vectors = null;
    private Map<String, PGEMatrix> matrixs = null;
    private Map<String, PGEGroup> groups = null;

    public PGEGroup(String name) {
        this.name = name;
        this.scalars = new HashMap<String, PGEScalar>();
        this.vectors = new HashMap<String, PGEVector>();
        this.matrixs = new HashMap<String, PGEMatrix>();
        this.groups = new HashMap<String, PGEGroup>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, PGEScalar> getScalars() {
        return this.scalars;
    }

    public void setScalars(Map<String, PGEScalar> scalars) {
        this.scalars = scalars;
    }

    public Map<String, PGEVector> getVectors() {
        return this.vectors;
    }

    public void setVectors(Map<String, PGEVector> vectors) {
        this.vectors = vectors;
    }

    public Map<String, PGEMatrix> getMatrixs() {
        return this.matrixs;
    }

    public void setMatrixs(Map<String, PGEMatrix> matrixs) {
        this.matrixs = matrixs;
    }

    public Map<String, PGEGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, PGEGroup> groups) {
        this.groups = groups;
    }

    public void addScalar(PGEScalar scalar) {
        if (this.scalars != null && !this.scalars.containsKey(scalar.getName())) {
            this.scalars.put(scalar.getName(), scalar);
        }
    }

    public void addVector(PGEVector vector) {
        if (this.vectors != null && !this.vectors.containsKey(vector.getName())) {
            this.vectors.put(vector.getName(), vector);
        }
    }

    public void addMatrix(PGEMatrix matrix) {
        if (this.matrixs != null && !this.matrixs.containsKey(matrix.getName())) {
            this.matrixs.put(matrix.getName(), matrix);
        }
    }

    public PGEScalar getScalar(String name) {
        if (this.scalars != null) {
            return this.scalars.get(name);
        }
        return null;
    }

    public PGEVector getVector(String name) {
        if (this.vectors != null) {
            return this.vectors.get(name);
        }
        return null;
    }

    public PGEMatrix getMatrix(String name) {
        if (this.matrixs != null) {
            return this.matrixs.get(name);
        }
        return null;
    }

    public PGEGroup getGroup(String name) {
        if (this.groups != null) {
            return this.groups.get(name);
        }
        return null;
    }

    public int getNumScalars() {
        if (this.scalars != null) {
            return this.scalars.size();
        }
        return 0;
    }

    public int getNumVectors() {
        if (this.vectors != null) {
            return this.vectors.size();
        }
        return 0;
    }

    public int getNumMatrixs() {
        if (this.matrixs != null) {
            return this.matrixs.size();
        }
        return 0;
    }

    public int getNumGroups() {
        if (this.groups != null) {
            return this.groups.size();
        }
        return 0;
    }
}

