/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.pcs.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.oodt.commons.xml.DOMUtil;
import org.apache.oodt.pcs.input.PGEConfigFileException;
import org.apache.oodt.pcs.input.PGEMatrix;
import org.apache.oodt.pcs.input.PGEScalar;
import org.apache.oodt.pcs.input.PGEVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class PGEXMLFileUtils {
    private static final Logger LOG = Logger.getLogger(PGEXMLFileUtils.class.getName());

    public static Map getMatrixsAsMap(Element group) throws PGEConfigFileException {
        NodeList matrixs = group.getElementsByTagName("matrix");
        if (matrixs == null) {
            return null;
        }
        HashMap<String, PGEMatrix> matrixMap = new HashMap<String, PGEMatrix>(matrixs.getLength());
        for (int i = 0; i < matrixs.getLength(); ++i) {
            Element matrix = (Element)matrixs.item(i);
            String matrixName = matrix.getAttribute("name");
            NodeList rowNodeList = matrix.getElementsByTagName("tr");
            if (rowNodeList == null || rowNodeList != null && rowNodeList.getLength() <= 0) {
                throw new PGEConfigFileException("there must be at least one row in a matrix!");
            }
            PGEMatrix pgeMatrix = new PGEMatrix();
            pgeMatrix.setName(matrixName);
            for (int j = 0; j < rowNodeList.getLength(); ++j) {
                Element rowElem = (Element)rowNodeList.item(j);
                NodeList colNodeList = rowElem.getElementsByTagName("td");
                if (colNodeList == null || colNodeList != null && colNodeList.getLength() <= 0) {
                    throw new PGEConfigFileException("there must be at least one column a matrix row!");
                }
                if (pgeMatrix.getNumCols() == 0) {
                    pgeMatrix.setNumCols(colNodeList.getLength());
                }
                Vector<String> colList = new Vector<String>(colNodeList.getLength());
                for (int k = 0; k < colNodeList.getLength(); ++k) {
                    Element colElement = (Element)colNodeList.item(k);
                    colList.add(DOMUtil.getSimpleElementText((Element)colElement));
                }
                pgeMatrix.getRows().add(colList);
            }
            matrixMap.put(pgeMatrix.getName(), pgeMatrix);
        }
        return matrixMap;
    }

    public static List getMatrixs(Element group) throws PGEConfigFileException {
        NodeList matrixs = group.getElementsByTagName("matrix");
        if (matrixs == null) {
            return null;
        }
        Vector<PGEMatrix> matrixList = new Vector<PGEMatrix>(matrixs.getLength());
        for (int i = 0; i < matrixs.getLength(); ++i) {
            Element matrix = (Element)matrixs.item(i);
            String matrixName = matrix.getAttribute("name");
            NodeList rowNodeList = matrix.getElementsByTagName("tr");
            if (rowNodeList == null || rowNodeList != null && rowNodeList.getLength() <= 0) {
                throw new PGEConfigFileException("there must be at least one row in a matrix!");
            }
            PGEMatrix pgeMatrix = new PGEMatrix();
            pgeMatrix.setName(matrixName);
            for (int j = 0; j < rowNodeList.getLength(); ++j) {
                Element rowElem = (Element)rowNodeList.item(j);
                NodeList colNodeList = rowElem.getElementsByTagName("td");
                if (colNodeList == null || colNodeList != null && colNodeList.getLength() <= 0) {
                    throw new PGEConfigFileException("there must be at least one column a matrix row!");
                }
                if (pgeMatrix.getNumCols() == 0) {
                    pgeMatrix.setNumCols(colNodeList.getLength());
                }
                Vector<String> colList = new Vector<String>(colNodeList.getLength());
                for (int k = 0; k < colNodeList.getLength(); ++k) {
                    Element colElement = (Element)colNodeList.item(k);
                    colList.add(DOMUtil.getSimpleElementText((Element)colElement));
                }
                pgeMatrix.getRows().add(colList);
            }
            matrixList.add(pgeMatrix);
        }
        return matrixList;
    }

    public static Map getScalarsAsMap(Element group) throws PGEConfigFileException {
        NodeList scalars = group.getElementsByTagName("scalar");
        if (scalars == null) {
            return null;
        }
        HashMap<String, PGEScalar> scalarMap = new HashMap<String, PGEScalar>(scalars.getLength());
        for (int i = 0; i < scalars.getLength(); ++i) {
            Element scalar = (Element)scalars.item(i);
            String scalarName = scalar.getAttribute("name");
            String scalarValue = DOMUtil.getSimpleElementText((Element)scalar);
            scalarMap.put(scalarName, new PGEScalar(scalarName, scalarValue));
        }
        return scalarMap;
    }

    public static List getScalars(Element group) throws PGEConfigFileException {
        NodeList scalars = group.getElementsByTagName("scalar");
        if (scalars == null) {
            return null;
        }
        Vector<PGEScalar> scalarList = new Vector<PGEScalar>(scalars.getLength());
        for (int i = 0; i < scalars.getLength(); ++i) {
            Element scalar = (Element)scalars.item(i);
            String scalarName = scalar.getAttribute("name");
            String scalarValue = DOMUtil.getSimpleElementText((Element)scalar);
            scalarList.add(new PGEScalar(scalarName, scalarValue));
        }
        return scalarList;
    }

    public static Map getVectorsAsMap(Element group) throws PGEConfigFileException {
        NodeList vectors = group.getElementsByTagName("vector");
        if (vectors == null) {
            return null;
        }
        HashMap<String, PGEVector> vectorMap = new HashMap<String, PGEVector>(vectors.getLength());
        for (int i = 0; i < vectors.getLength(); ++i) {
            Element vector = (Element)vectors.item(i);
            String vectorName = vector.getAttribute("name");
            PGEVector vec = new PGEVector();
            vec.setName(vectorName);
            NodeList vecElems = vector.getElementsByTagName("element");
            if (vecElems == null || vecElems != null && vecElems.getLength() <= 0) {
                throw new PGEConfigFileException("There must be at least one element in a PGEVector!");
            }
            Vector<Object> vecElemList = new Vector<Object>(vecElems.getLength());
            for (int j = 0; j < vecElems.getLength(); ++j) {
                Element vecElem = (Element)vecElems.item(j);
                vecElemList.add(DOMUtil.getSimpleElementText((Element)vecElem));
            }
            vec.setElements(vecElemList);
            vectorMap.put(vec.getName(), vec);
        }
        return vectorMap;
    }

    public static List getVectors(Element group) throws PGEConfigFileException {
        NodeList vectors = group.getElementsByTagName("vector");
        if (vectors == null) {
            return null;
        }
        Vector<PGEVector> vectorList = new Vector<PGEVector>(vectors.getLength());
        for (int i = 0; i < vectors.getLength(); ++i) {
            Element vector = (Element)vectors.item(i);
            String vectorName = vector.getAttribute("name");
            PGEVector vec = new PGEVector();
            vec.setName(vectorName);
            NodeList vecElems = vector.getElementsByTagName("element");
            if (vecElems == null || vecElems != null && vecElems.getLength() <= 0) {
                throw new PGEConfigFileException("There must be at least one element in a PGEVector!");
            }
            Vector<Object> vecElemList = new Vector<Object>(vecElems.getLength());
            for (int j = 0; j < vecElems.getLength(); ++j) {
                Element vecElem = (Element)vecElems.item(j);
                vecElemList.add(DOMUtil.getSimpleElementText((Element)vecElem));
            }
            vec.setElements(vecElemList);
            vectorList.add(vec);
        }
        return vectorList;
    }

    public static Document getDocumentRoot(String xmlFile) {
        DocumentBuilderFactory factory = null;
        DocumentBuilder parser = null;
        Document document = null;
        InputSource inputSource = null;
        InputStream xmlInputStream = null;
        try {
            xmlInputStream = new File(xmlFile).toURL().openStream();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "IOException when getting input stream from [" + xmlFile + "]: returning null document root");
            return null;
        }
        inputSource = new InputSource(xmlInputStream);
        try {
            factory = DocumentBuilderFactory.newInstance();
            parser = factory.newDocumentBuilder();
            document = parser.parse(inputSource);
        }
        catch (Exception e) {
            LOG.warning("Unable to parse xml file [" + xmlFile + "]." + "Reason is [" + e + "]");
            return null;
        }
        return document;
    }
}

