/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;

public class ValidationEventImpl
implements ValidationEvent {
    private int severity;
    private String message;
    private Throwable linkedException;
    private ValidationEventLocator locator;

    public ValidationEventImpl(int severity, String message, ValidationEventLocator locator) {
        this(severity, message, locator, null);
    }

    public ValidationEventImpl(int severity, String message, ValidationEventLocator locator, Throwable linkedException) {
        this.setSeverity(severity);
        this.message = message;
        this.locator = locator;
        this.linkedException = linkedException;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        if (severity != 0 && severity != 1 && severity != 2) {
            throw new IllegalArgumentException("Illegal severity");
        }
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getLinkedException() {
        return this.linkedException;
    }

    public void setLinkedException(Throwable linkedException) {
        this.linkedException = linkedException;
    }

    public ValidationEventLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ValidationEventLocator locator) {
        this.locator = locator;
    }

    public String toString() {
        String s;
        switch (this.getSeverity()) {
            case 0: {
                s = "WARNING";
                break;
            }
            case 1: {
                s = "ERROR";
                break;
            }
            case 2: {
                s = "FATAL_ERROR";
                break;
            }
            default: {
                s = String.valueOf(this.getSeverity());
            }
        }
        return "[severity=" + s + ", message=" + this.getMessage() + ", locator=" + this.getLocator() + "]";
    }
}

