/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.proxy.ProxyEJB;

public class OpenEJBScripter {
    private static final Map<String, ScriptEngineFactory> ENGINE_FACTORIES = new ConcurrentHashMap<String, ScriptEngineFactory>();
    private static final ThreadLocal<Map<String, ScriptEngine>> ENGINES = new ThreadLocal<Map<String, ScriptEngine>>(){

        @Override
        protected Map<String, ScriptEngine> initialValue() {
            return new HashMap<String, ScriptEngine>();
        }
    };

    public Object evaluate(String language, String script) throws ScriptException {
        if (!ENGINE_FACTORIES.containsKey(language)) {
            throw new IllegalArgumentException("can't find factory for language " + language + ". You probably need to add the jar to openejb libs.");
        }
        ScriptEngine engine = OpenEJBScripter.engine(language);
        return engine.eval(script);
    }

    private static ScriptEngine engine(String language) {
        ScriptEngine engine = ENGINES.get().get(language);
        if (engine == null) {
            ScriptEngineFactory factory = ENGINE_FACTORIES.get(language);
            engine = factory.getScriptEngine();
            engine.setBindings(OpenEJBScripter.binding(), 100);
            ENGINES.get().put(language, engine);
        }
        return engine;
    }

    public static void clearEngines() {
        ENGINES.get().clear();
    }

    private static Bindings binding() {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("bm", (Object)new BeanManagerHelper());
        ContainerSystem cs = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        for (BeanContext beanContext : cs.deployments()) {
            if (BeanContext.Comp.class.equals((Object)beanContext.getBeanClass())) continue;
            Object service = null;
            if (beanContext.getBusinessLocalInterface() != null) {
                service = ProxyEJB.proxy((BeanContext)beanContext, (Class[])beanContext.getBusinessLocalInterfaces().toArray(new Class[beanContext.getBusinessLocalInterfaces().size()]));
            } else if (beanContext.isLocalbean()) {
                service = ProxyEJB.proxy((BeanContext)beanContext, (Class[])new Class[]{beanContext.getBusinessLocalBeanInterface()});
            } else if (beanContext.getBusinessRemoteInterface() != null) {
                service = ProxyEJB.proxy((BeanContext)beanContext, (Class[])beanContext.getBusinessRemoteInterfaces().toArray(new Class[beanContext.getBusinessRemoteInterfaces().size()]));
            }
            if (service == null) continue;
            bindings.put(beanContext.getEjbName().replaceAll("[^a-zA-Z0-9]", "_"), service);
        }
        return bindings;
    }

    static {
        ScriptEngineManager mgr = new ScriptEngineManager();
        for (ScriptEngineFactory factory : mgr.getEngineFactories()) {
            if (factory.getParameter("THREADING") == null) continue;
            for (String ext : factory.getExtensions()) {
                ENGINE_FACTORIES.put(ext, factory);
            }
        }
    }

    public static class BeanManagerHelper {
        public Object beanFromClass(String appName, String classname) {
            Class<?> clazz;
            AppContext appContext = this.appContext(appName);
            BeanManager bm = appContext.getBeanManager();
            try {
                clazz = appContext.getClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBRuntimeException((Exception)e);
            }
            Set beans = bm.getBeans(clazz, new Annotation[0]);
            return this.instance(bm, beans, clazz);
        }

        public Object beanFromName(String appName, String name) {
            BeanManager bm = this.beanManager(appName);
            Set beans = bm.getBeans(name);
            return this.instance(bm, beans, Object.class);
        }

        private <T> T instance(BeanManager bm, Set<Bean<?>> beans, Class<T> clazz) {
            Bean bean = bm.resolve(beans);
            return (T)bm.getReference(bean, clazz, bm.createCreationalContext((Contextual)bean));
        }

        private BeanManager beanManager(String appName) {
            return this.appContext(appName).getBeanManager();
        }

        private AppContext appContext(String appName) {
            ContainerSystem cs = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            AppContext appContext = cs.getAppContext((Object)appName);
            if (appContext == null) {
                throw new OpenEJBRuntimeException("can't find application " + appName);
            }
            return appContext;
        }
    }
}

