/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.openejb.loader.IO;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.server.cli.command.PathCommand;

@Command(name="cat", usage="cat <path>", description="cat a file (in tomee directories only)")
public class CatCommand
extends PathCommand {
    @Override
    public void execute(String cmd) {
        File file;
        try {
            file = this.resolve("cat", cmd);
        }
        catch (IllegalArgumentException iae) {
            this.streamManager.writeErr(iae.getMessage());
            return;
        }
        if (file.isDirectory() && file.exists()) {
            this.streamManager.writeOut("file " + file.getPath() + " is a directory, please specify a regular file");
        } else if (file.exists()) {
            try {
                this.cat(file);
            }
            catch (IOException e) {
                this.streamManager.writeErr(e);
            }
        } else {
            this.streamManager.writeOut("file " + file.getPath() + " doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cat(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        int lineNumber = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                this.streamManager.writeOut(String.format("%3d. %s", ++lineNumber, line));
            }
        }
        finally {
            IO.close((Closeable)br);
        }
    }
}

