/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.util.Arrays;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.server.cli.command.AbstractCommand;
import org.apache.openejb.server.cli.command.Command;
import org.apache.xbean.propertyeditor.PropertyEditors;

@Command(name="jmx", description="consult/update a jmx information", usage="jmx <operation> <options>. \n\t\tOperation can be set|get|invoke.\n\t\tLast value is always the object name canonical path.\n\t\tSet takes the new value as last value and the name of the attribute as second parameter.\n\t\tInvoke takes the method invocation as second parameter.\n\t\tSamples:\n\t\t\tjmx get MyAttributeName foo:type=bar\n\t\t\tjmx set MyAttributeName foo:type=bar NewValue\n\t\t\tjmx invoke myMethod(arg1,arg2) foo:type=bar")
public class LocalJMXCommand
extends AbstractCommand {
    @Override
    public void execute(String cmd) {
        String jmxCmd = cmd.substring("jmx".length()).trim();
        if ("list".equals(jmxCmd)) {
            this.listMBeans();
            return;
        }
        if (!jmxCmd.contains(" ")) {
            this.streamManager.writeErr("the command is not correct");
            return;
        }
        int space = jmxCmd.indexOf(" ");
        String command = jmxCmd.substring(0, space);
        String value = jmxCmd.substring(command.length()).trim();
        if ("get".equals(command)) {
            this.get(value);
        } else if ("set".equals(command)) {
            this.set(value);
        } else if ("invoke".equals(command)) {
            this.invoke(value);
        } else {
            this.streamManager.writeOut("unknown command '" + command + "'");
        }
    }

    private void invoke(String value) {
        ObjectName on;
        if (!value.contains("(") || !value.contains(")")) {
            this.streamManager.writeErr("method should follow the format: <methoName>(<arg1>,<arg2>,...)");
            return;
        }
        int open = value.indexOf("(");
        int close = value.lastIndexOf(")");
        String name = value.substring(0, open).trim();
        String rawArgs = value.substring(open + 1, close).trim();
        try {
            on = new ObjectName(value.substring(close + 1).trim());
        }
        catch (MalformedObjectNameException e) {
            this.streamManager.writeErr(e);
            return;
        }
        MBeanServer server = LocalMBeanServer.get();
        String[] args = rawArgs == null || rawArgs.isEmpty() ? new String[]{} : rawArgs.split(",");
        try {
            MBeanInfo minfo = server.getMBeanInfo(on);
            MBeanOperationInfo[] methods = minfo.getOperations();
            MBeanOperationInfo operation = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name)) continue;
                operation = methods[i];
                break;
            }
            if (operation == null) {
                this.streamManager.writeErr("can't find operation '" + name + "'");
                return;
            }
            Object[] passedArgs = new Object[args.length];
            String[] passedArgTypes = new String[args.length];
            for (int i = 0; i < passedArgs.length; ++i) {
                String expected = operation.getSignature()[i].getType();
                passedArgs[i] = !String.class.getName().equals(expected) ? PropertyEditors.getValue((String)expected, (String)args[i], (ClassLoader)Thread.currentThread().getContextClassLoader()) : args[i];
                passedArgTypes[i] = expected;
            }
            this.streamManager.writeOut(this.stringify(server.invoke(on, name, passedArgs, passedArgTypes)));
        }
        catch (Exception e) {
            this.streamManager.writeErr(e);
            return;
        }
    }

    private void get(String cmd) {
        int space = cmd.indexOf(" ");
        if (space < 0) {
            this.streamManager.writeErr("you need to specify an attribute and an objectname");
            return;
        }
        String attr = cmd.substring(0, space);
        String on = cmd.substring(space, cmd.length()).trim();
        MBeanServer mBeanServer = LocalMBeanServer.get();
        try {
            ObjectName oname = new ObjectName(on);
            Object value = mBeanServer.getAttribute(oname, attr);
            this.streamManager.writeOut("Attribute [" + on + " -> " + attr + "] = " + this.stringify(value));
        }
        catch (Exception ex) {
            this.streamManager.writeErr(ex);
        }
    }

    private void set(String cmd) {
        String[] split = cmd.split(" ");
        if (split.length < 2) {
            this.streamManager.writeErr("you need to specify an attribute, an objectname and a value");
            return;
        }
        MBeanServer mBeanServer = LocalMBeanServer.get();
        String newValue = cmd.substring(split[0].length() + split[1].length() + 1).trim();
        try {
            ObjectName oname = new ObjectName(split[1]);
            MBeanInfo minfo = mBeanServer.getMBeanInfo(oname);
            MBeanAttributeInfo[] attrs = minfo.getAttributes();
            String type = String.class.getName();
            for (int i = 0; i < attrs.length; ++i) {
                if (!attrs[i].getName().equals(split[0])) continue;
                type = attrs[i].getType();
                break;
            }
            Object valueObj = PropertyEditors.getValue((String)type, (String)newValue, (ClassLoader)Thread.currentThread().getContextClassLoader());
            mBeanServer.setAttribute(oname, new Attribute(split[0], valueObj));
            this.streamManager.writeOut("done");
        }
        catch (Exception ex) {
            this.streamManager.writeOut("Error - " + ex.toString());
        }
    }

    private String stringify(Object value) {
        if (value == null) {
            return "<null>";
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value).toString();
        }
        return value.toString();
    }

    private void listMBeans() {
        Set<ObjectName> names;
        MBeanServer mBeanServer = LocalMBeanServer.get();
        try {
            names = mBeanServer.queryNames(null, null);
        }
        catch (Exception e) {
            this.streamManager.writeErr(e);
            return;
        }
        for (ObjectName oname : names) {
            this.streamManager.writeOut("Name: " + oname.toString());
            try {
                MBeanInfo minfo = mBeanServer.getMBeanInfo(oname);
                String code = minfo.getClassName();
                if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                    code = (String)mBeanServer.getAttribute(oname, "modelerType");
                }
                this.streamManager.writeOut("  + modelerType: " + code);
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                Object value = null;
                for (int i = 0; i < attrs.length; ++i) {
                    String attName;
                    if (!attrs[i].isReadable() || "modelerType".equals(attName = attrs[i].getName()) || attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) continue;
                    try {
                        value = mBeanServer.getAttribute(oname, attName);
                    }
                    catch (RuntimeMBeanException uoe) {
                    }
                    catch (Throwable t) {
                        this.streamManager.writeErr(new Exception(t));
                        continue;
                    }
                    try {
                        String valueString = this.stringify(value);
                        this.streamManager.writeOut("  + " + attName + ": " + valueString);
                        continue;
                    }
                    catch (Throwable t) {
                        this.streamManager.writeErr(new Exception(t));
                    }
                }
            }
            catch (Throwable t) {
                this.streamManager.writeErr(new Exception(t));
            }
            this.streamManager.writeOut("");
        }
    }
}

