/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.Context;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JSONProvider;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.server.cxf.rs.OpenEJBEJBInvoker;
import org.apache.openejb.server.cxf.rs.OpenEJBPerRequestPojoResourceProvider;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.rest.RsHttpListener;

public class CxfRsHttpListener
implements RsHttpListener {
    private static final List<?> PROVIDERS = CxfRsHttpListener.createProviderList();
    private HTTPTransportFactory transportFactory;
    private AbstractHTTPDestination destination;
    private Server server;

    public CxfRsHttpListener(HTTPTransportFactory httpTransportFactory) {
        this.transportFactory = httpTransportFactory;
    }

    public void onMessage(final HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        this.destination.invoke(null, httpRequest.getServletContext(), (HttpServletRequest)new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

            public String getRequestURI() {
                try {
                    return new URI(httpRequest.getRequestURI()).getRawPath();
                }
                catch (URISyntaxException e) {
                    return "/";
                }
            }
        }, (HttpServletResponse)httpResponse);
    }

    public void deploySingleton(String fullContext, Object o, Application appInstance) {
        this.deploy(o.getClass(), fullContext, (ResourceProvider)new SingletonResourceProvider(o), o, appInstance, null);
    }

    public void deployPojo(String fullContext, Class<?> loadedClazz, Application app, Collection<Injection> injections, Context context) {
        this.deploy(loadedClazz, fullContext, (ResourceProvider)new OpenEJBPerRequestPojoResourceProvider(loadedClazz, injections, context), null, app, null);
    }

    public void deployEJB(String fullContext, BeanContext beanContext) {
        this.deploy(beanContext.getBeanClass(), fullContext, null, null, null, (Invoker)new OpenEJBEJBInvoker(beanContext));
    }

    private void deploy(Class<?> clazz, String address, ResourceProvider rp, Object serviceBean, Application app, Invoker invoker) {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setResourceClasses(new Class[]{clazz});
        factory.setDestinationFactory((DestinationFactory)this.transportFactory);
        factory.setBus(this.transportFactory.getBus());
        factory.setAddress(address);
        factory.setProviders(PROVIDERS);
        if (rp != null) {
            factory.setResourceProvider(rp);
        }
        if (app != null) {
            factory.setApplication(app);
        }
        if (invoker != null) {
            factory.setInvoker(invoker);
        }
        if (serviceBean != null) {
            factory.setServiceBean(serviceBean);
        } else {
            factory.setServiceClass(clazz);
        }
        this.server = factory.create();
        this.destination = (AbstractHTTPDestination)this.server.getDestination();
    }

    public void undeploy() {
        this.server.stop();
    }

    private static List<?> createProviderList() {
        JAXBElementProvider jaxb = new JAXBElementProvider();
        HashMap<String, Boolean> jaxbProperties = new HashMap<String, Boolean>();
        jaxbProperties.put("jaxb.fragment", true);
        jaxb.setMarshallerProperties(jaxbProperties);
        JSONProvider json = new JSONProvider();
        json.setSerializeAsArray(true);
        return Arrays.asList(jaxb, json);
    }
}

