/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.server.cxf.rs.ContextReferenceTypes;
import org.apache.openejb.server.cxf.rs.NoopResourceProvider;
import org.apache.openejb.server.cxf.rs.OpenEJBEJBInvoker;
import org.apache.openejb.server.cxf.rs.OpenEJBPerRequestPojoResourceProvider;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.ProxyEJB;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;

public class CxfRsHttpListener
implements RsHttpListener {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_RS, CxfRsHttpListener.class);
    public static final String CXF_JAXRS_PREFIX = "cxf.jaxrs.";
    public static final String PROVIDERS_KEY = "cxf.jaxrs.providers";
    private final HTTPTransportFactory transportFactory;
    private AbstractHTTPDestination destination;
    private Server server;
    private String context = "";

    public CxfRsHttpListener(HTTPTransportFactory httpTransportFactory) {
        this.transportFactory = httpTransportFactory;
    }

    public void onMessage(final HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        this.destination.invoke(null, httpRequest.getServletContext(), (HttpServletRequest)new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

            public String getRequestURI() {
                if (httpRequest instanceof HttpRequestImpl) {
                    return CxfRsHttpListener.this.strip(CxfRsHttpListener.this.context, ((HttpRequestImpl)httpRequest).requestRawPath());
                }
                return CxfRsHttpListener.this.strip(CxfRsHttpListener.this.context, super.getRequestURI());
            }
        }, (HttpServletResponse)httpResponse);
    }

    private String strip(String context, String requestURI) {
        if (requestURI.startsWith(context)) {
            return requestURI.substring(context.length());
        }
        return requestURI;
    }

    public void deploySingleton(String fullContext, Object o, Application appInstance, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(o.getClass(), fullContext, (ResourceProvider)new SingletonResourceProvider(o), o, appInstance, null, additionalProviders, configuration);
    }

    public void deployPojo(String fullContext, Class<?> loadedClazz, Application app, Collection<Injection> injections, javax.naming.Context context, WebBeansContext owbCtx, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(loadedClazz, fullContext, new OpenEJBPerRequestPojoResourceProvider(loadedClazz, injections, context, owbCtx), null, app, null, additionalProviders, configuration);
    }

    public void deployEJB(String fullContext, BeanContext beanContext, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        Object proxy = ProxyEJB.subclassProxy((BeanContext)beanContext);
        this.addContextTypes(beanContext);
        this.deploy(beanContext.getBeanClass(), fullContext, new NoopResourceProvider(beanContext.getBeanClass(), proxy), proxy, null, (Invoker)new OpenEJBEJBInvoker(), additionalProviders, configuration);
    }

    private void addContextTypes(BeanContext beanContext) {
        HashSet classes = new HashSet();
        classes.addAll(Classes.ancestors((Class)beanContext.getBeanClass()));
        for (InterceptorData interceptorData : beanContext.getInstanceScopedInterceptors()) {
            classes.addAll(Classes.ancestors((Class)interceptorData.getInterceptorClass()));
        }
        AnnotationFinder finder = new AnnotationFinder((Archive)new ClassesArchive(classes));
        List fields = finder.findAnnotatedFields(Context.class);
        HashSet contextTypes = new HashSet();
        for (Field field : fields) {
            contextTypes.add(field.getType());
        }
        beanContext.set(ContextReferenceTypes.class, (Object)new ContextReferenceTypes(contextTypes));
    }

    private void deploy(Class<?> clazz, String address, ResourceProvider rp, Object serviceBean, Application app, Invoker invoker, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        JAXRSServerFactoryBean factory = this.newFactory(address);
        this.configureFactory(additionalProviders, configuration, factory);
        factory.setResourceClasses(new Class[]{clazz});
        if (rp != null) {
            factory.setResourceProvider(rp);
        }
        if (app != null) {
            factory.setApplication(app);
        }
        if (invoker != null) {
            factory.setInvoker(invoker);
        }
        if (serviceBean != null) {
            factory.setServiceBean(serviceBean);
        } else {
            factory.setServiceClass(clazz);
        }
        this.server = factory.create();
        this.destination = (AbstractHTTPDestination)this.server.getDestination();
    }

    private Collection<Object> providers(Collection<ServiceInfo> services, Collection<Object> additionalProviders) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (Object o : additionalProviders) {
            if (o instanceof Class) {
                Class clazz = (Class)o;
                Object instance = ServiceInfos.resolve(services, (String)clazz.getName());
                if (instance != null) {
                    instances.add(instance);
                    continue;
                }
                try {
                    instances.add(clazz.newInstance());
                }
                catch (Exception e) {
                    LOGGER.error("can't instantiate " + clazz.getName(), (Throwable)e);
                }
                continue;
            }
            instances.add(o);
        }
        return instances;
    }

    public void undeploy() {
        this.server.stop();
    }

    private JAXRSServerFactoryBean newFactory(String prefix) {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setDestinationFactory((DestinationFactory)this.transportFactory);
        factory.setBus(this.transportFactory.getBus());
        factory.setAddress(prefix);
        return factory;
    }

    private void configureFactory(Collection<Object> additionalProviders, ServiceConfiguration serviceConfiguration, JAXRSServerFactoryBean factory) {
        CxfUtil.configureEndpoint((AbstractEndpointFactory)factory, (ServiceConfiguration)serviceConfiguration, (String)CXF_JAXRS_PREFIX);
        Collection services = serviceConfiguration.getAvailableServices();
        String provider = serviceConfiguration.getProperties().getProperty(PROVIDERS_KEY);
        ArrayList<Object> providers = null;
        if (provider != null) {
            providers = ServiceInfos.resolve((Collection)services, (String[])provider.split(","));
            if (providers != null && additionalProviders != null && !additionalProviders.isEmpty()) {
                providers.addAll(this.providers(services, additionalProviders));
            }
            factory.setProviders(providers);
        }
        if (providers == null) {
            providers = new ArrayList<Object>();
            if (additionalProviders != null && !additionalProviders.isEmpty()) {
                providers.addAll(this.providers(services, additionalProviders));
            } else {
                providers.addAll(CxfRsHttpListener.defaultProviders());
            }
            factory.setProviders(providers);
        }
    }

    private static List<Object> defaultProviders() {
        JAXBElementProvider jaxb = new JAXBElementProvider();
        HashMap<String, Boolean> jaxbProperties = new HashMap<String, Boolean>();
        jaxbProperties.put("jaxb.fragment", true);
        jaxb.setMarshallerProperties(jaxbProperties);
        JSONProvider json = new JSONProvider();
        return Arrays.asList(jaxb, json);
    }
}

