/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.javaagent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;

public class Agent {
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    private static String agentArgs;
    private static Instrumentation instrumentation;
    private static boolean initialized;

    public static synchronized void premain(String agentArgs, Instrumentation instrumentation) {
        Agent.agentArgs = agentArgs;
        Agent.instrumentation = instrumentation;
        initialized = true;
    }

    public static synchronized String getAgentArgs() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        Agent.checkInitialization();
        return agentArgs;
    }

    public static synchronized Instrumentation getInstrumentation() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        Agent.checkInitialization();
        return instrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void checkInitialization() {
        if (!initialized) {
            try {
                Class<?> systemAgentClass = null;
                try {
                    ClassLoader systemCl = ClassLoader.getSystemClassLoader();
                    systemAgentClass = systemCl.loadClass(Agent.class.getName());
                }
                catch (ClassNotFoundException e) {
                    initialized = true;
                    return;
                }
                Field instrumentationField = systemAgentClass.getDeclaredField("instrumentation");
                instrumentationField.setAccessible(true);
                instrumentation = (Instrumentation)instrumentationField.get(null);
                Field agentArgsField = systemAgentClass.getDeclaredField("agentArgs");
                agentArgsField.setAccessible(true);
                agentArgs = (String)agentArgsField.get(null);
            }
            catch (Exception e) {
                new IllegalStateException("Unable to initialize agent", e).printStackTrace();
            }
            finally {
                initialized = true;
            }
        }
    }

    static {
        initialized = false;
    }
}

