/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee.jpa.unit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class JaxbPersistenceFactory {
    public static final String PERSISTENCE_SCHEMA = "http://java.sun.com/xml/ns/persistence";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Persistence getPersistence(URL url) throws Exception {
        InputStream persistenceDescriptor = null;
        try {
            persistenceDescriptor = url.openStream();
            JAXBContext jc = JAXBContextFactory.newInstance(Persistence.class);
            Unmarshaller u = jc.createUnmarshaller();
            UnmarshallerHandler uh = u.getUnmarshallerHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            PersistenceFilter xmlFilter = new PersistenceFilter(xmlReader);
            xmlFilter.setContentHandler((ContentHandler)uh);
            SAXSource source = new SAXSource(xmlFilter, new InputSource(persistenceDescriptor));
            Persistence persistence = (Persistence)u.unmarshal((Source)source);
            return persistence;
        }
        finally {
            if (persistenceDescriptor != null) {
                persistenceDescriptor.close();
            }
        }
    }

    public static class PersistenceFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public PersistenceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }
    }
}

