/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resolver.maven;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import org.apache.openejb.resolver.maven.AetherBasedResolver;
import org.apache.openejb.resolver.maven.ConfigHelper;
import org.apache.openejb.resolver.maven.Parser;
import org.ops4j.pax.url.maven.commons.MavenConfigurationImpl;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.version.Version;

public final class VersionResolver {
    private VersionResolver() {
    }

    public static VersionRangeResult versions(String info, String defaultVersion) {
        MavenConfigurationImpl config = ConfigHelper.createConfig();
        try {
            Parser parser = new Parser(info);
            AetherBasedResolver resolver = new AetherBasedResolver(config, parser.getRepositoryURL());
            return resolver.resolveVersions(parser.getGroup(), parser.getArtifact(), parser.getClassifier(), parser.getType(), parser.getVersion());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String highestVersion(String info, String prefix, String defaultVersion) {
        VersionRangeResult result = VersionResolver.versions(info, defaultVersion);
        if (result == null) {
            return defaultVersion;
        }
        List versions = result.getVersions();
        Collections.sort(versions);
        Version usedVersion = null;
        for (Version current : versions) {
            if (!current.toString().startsWith(prefix)) continue;
            usedVersion = current;
        }
        if (usedVersion != null) {
            return usedVersion.toString();
        }
        return defaultVersion;
    }
}

