/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.myfaces;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.DefaultFacesConfigResourceProvider;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.loader.Files;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;

public class TomEEFacesConfigResourceProvider
extends DefaultFacesConfigResourceProvider {
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String FACES_CONFIG_IMPLICIT = "META-INF/faces-config.xml";
    private static final Map<ClassLoader, Collection<URL>> CACHED_RESOURCES = new HashMap<ClassLoader, Collection<URL>>();

    public Collection<URL> getMetaInfConfigurationResources(ExternalContext context) throws IOException {
        ClassLoader loader = this.getClassLoader();
        Collection<URL> urlSet = CACHED_RESOURCES.get(loader);
        if (urlSet != null) {
            return new HashSet<URL>(urlSet);
        }
        urlSet = new HashSet<URL>();
        Enumeration<URL> resources = loader.getResources(FACES_CONFIG_IMPLICIT);
        while (resources.hasMoreElements()) {
            urlSet.add(resources.nextElement());
        }
        for (URL url : NewLoaderLogic.applyBuiltinExcludes((UrlSet)new UrlSet(loader)).getUrls()) {
            File file = URLs.toFile((URL)url);
            if (!file.exists()) continue;
            if (!file.isDirectory()) {
                Enumeration<JarEntry> e = new JarFile(file).entries();
                while (e.hasMoreElements()) {
                    try {
                        String name = e.nextElement().getName();
                        if (!name.startsWith(META_INF_PREFIX) || !name.endsWith(FACES_CONFIG_SUFFIX)) continue;
                        Enumeration<URL> e2 = loader.getResources(name);
                        while (e2.hasMoreElements()) {
                            urlSet.add(e2.nextElement());
                        }
                    }
                    catch (Throwable ignored) {
                    }
                }
                continue;
            }
            File metaInf = new File(file, META_INF_PREFIX);
            if (!metaInf.exists() || !metaInf.isDirectory()) continue;
            for (File f : Files.collect((File)metaInf, (FileFilter)FacesConfigSuffixFilter.INSTANCE)) {
                if (f.isDirectory()) continue;
                urlSet.add(f.toURI().toURL());
            }
        }
        CACHED_RESOURCES.put(loader, urlSet);
        return new HashSet<URL>(urlSet);
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        return loader;
    }

    public static void clear(ClassLoader loader) {
        CACHED_RESOURCES.remove(loader);
    }

    private static class FacesConfigSuffixFilter
    implements FileFilter {
        public static final FacesConfigSuffixFilter INSTANCE = new FacesConfigSuffixFilter();

        private FacesConfigSuffixFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(TomEEFacesConfigResourceProvider.FACES_CONFIG_SUFFIX);
        }
    }
}

