/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ziplock.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.ziplock.IO;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;

public final class Mvn {
    public static Archive<?> war() {
        return new Builder().build();
    }

    public static Archive<?> testWar() {
        return new Builder().scopes(ScopeType.COMPILE, ScopeType.RUNTIME, ScopeType.TEST).build();
    }

    private Mvn() {
    }

    public static class KnownResourcesFilter
    implements Filter<ArchivePath> {
        private final File base;
        private final String prefix;
        private final Map<ArchivePath, Asset> paths = new HashMap<ArchivePath, Asset>();
        private final Filter<ArchivePath> delegate;

        public KnownResourcesFilter(File base, String prefix, Filter<ArchivePath> filter) {
            this.base = base;
            this.delegate = filter;
            this.prefix = prefix.startsWith("/") ? prefix.substring(1) : prefix;
        }

        public boolean include(ArchivePath archivePath) {
            if (!this.delegate.include((Object)archivePath)) {
                return false;
            }
            if (archivePath.get().contains("shiro.ini")) {
                this.paths.put(archivePath, this.addArquillianServletInUrls(archivePath));
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Asset addArquillianServletInUrls(ArchivePath archivePath) {
            File f = new File(this.base, archivePath.get());
            if (!f.exists()) {
                throw new IllegalArgumentException("Can't find " + archivePath.get());
            }
            String ln = System.getProperty("line.separator");
            StringWriter out = new StringWriter();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(f));
                while ((line = reader.readLine()) != null) {
                    out.write(line + ln);
                    if (!"[urls]".equals(line)) continue;
                    out.write("/ArquillianServletRunner = anon" + ln);
                }
            }
            catch (IOException e) {
                try {
                    throw new IllegalArgumentException(e);
                }
                catch (Throwable throwable) {
                    try {
                        IO.close(reader);
                        throw throwable;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                IO.close(reader);
                return new StringAsset(out.toString());
            }
            catch (IOException e) {
                return new StringAsset(out.toString());
            }
        }

        public void update(Archive<?> archive) {
            for (Map.Entry<ArchivePath, Asset> r : this.paths.entrySet()) {
                archive.add(r.getValue(), this.prefix + r.getKey().get());
            }
        }
    }

    public static class Builder {
        private File basedir;
        private File resources;
        private File webapp;
        private File classes;
        private String basePackage;
        private String name = "test.war";
        private Map<File, String> additionalResources = new HashMap<File, String>();
        private ScopeType[] scopes = new ScopeType[]{ScopeType.COMPILE, ScopeType.RUNTIME};
        private Filter<ArchivePath> filter = Filters.includeAll();

        public Builder scopes(ScopeType ... scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder basedir(File path) {
            this.basedir = path;
            return this;
        }

        public Builder resources(File path) {
            this.resources = path;
            return this;
        }

        public Builder webapp(File path) {
            this.webapp = path;
            return this;
        }

        public Builder classes(File path) {
            this.classes = path;
            return this;
        }

        public Builder applicationPackage(String base) {
            this.basePackage = base;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder filter(Filter<ArchivePath> filter) {
            this.filter = filter;
            return this;
        }

        public Builder additionalResource(File folder, String root) {
            this.additionalResources.put(folder, root);
            return this;
        }

        public Archive<?> build() {
            return this.build(WebArchive.class);
        }

        public <T extends Archive<?>> T build(Class<T> type) {
            this.initDefaults();
            Archive webArchive = (Archive)ShrinkWrap.create(type, (String)this.name);
            if (this.basePackage != null && ClassContainer.class.isInstance(webArchive)) {
                ClassContainer container = (ClassContainer)ClassContainer.class.cast(webArchive);
                if (this.filter != null) {
                    container.addPackages(true, this.filter, new String[]{this.basePackage});
                } else {
                    container.addPackages(true, new String[]{this.basePackage});
                }
            }
            String root = WebContainer.class.isInstance(webArchive) ? "/WEB-INF/classes" : "/";
            this.add(webArchive, this.classes, root).add(webArchive, this.resources, root).add(webArchive, this.webapp, "/");
            for (Map.Entry<File, String> additionalResource : this.additionalResources.entrySet()) {
                this.add(webArchive, additionalResource.getKey(), additionalResource.getValue());
            }
            if (LibraryContainer.class.isInstance(webArchive)) {
                try {
                    File[] deps = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)((ConfigurableMavenResolverSystem)Maven.configureResolver().workOffline()).loadPomFromFile(new File(this.basedir, "pom.xml"))).importDependencies(this.scopes)).resolve()).withTransitivity()).asFile();
                    if (deps.length > 0) {
                        ((LibraryContainer)LibraryContainer.class.cast(webArchive)).addAsLibraries(deps);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return (T)webArchive;
        }

        private File basedir() {
            if (this.basedir != null) {
                return this.basedir;
            }
            File file = new File("pom.xml");
            if (file.exists()) {
                return new File(".");
            }
            file = new File("../pom.xml");
            if (file.exists()) {
                return new File("..");
            }
            throw new IllegalStateException("basedir not found");
        }

        private void initDefaults() {
            File basedir = this.basedir();
            if (this.classes == null && this.basePackage == null) {
                this.classes = new File(basedir, "target/classes");
            }
            if (this.resources == null && this.basePackage != null) {
                this.resources = new File(basedir, "src/main/resources");
            }
            if (this.webapp == null) {
                this.webapp = new File(basedir, "src/main/webapp");
            }
        }

        private Builder add(Archive<?> webArchive, File dir, String root) {
            if (dir == null || !dir.exists()) {
                return this;
            }
            KnownResourcesFilter filter = new KnownResourcesFilter(dir, root, this.filter);
            filter.update(webArchive.merge((Archive)((ExplodedImporter)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).as(ExplodedImporter.class)).importDirectory(dir).as(GenericArchive.class), root, (Filter)filter));
            return this;
        }
    }
}

