/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.FetchConfigurationImpl;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.Localizer;

public abstract class AbstractHintHandler
implements Serializable {
    private static final Localizer _loc = Localizer.forPackage(AbstractHintHandler.class);
    protected static final String DOT = ".";
    protected static final String BLANK = "";
    protected static final String PREFIX_OPENJPA = "openjpa.";
    protected static final String PREFIX_JDBC = "openjpa.jdbc.";
    protected FetchConfigurationImpl _fConfig;

    public AbstractHintHandler(FetchConfigurationImpl fConfig) {
        this._fConfig = fConfig;
    }

    protected abstract boolean setHintInternal(String var1, Object var2, boolean var3);

    public boolean setHint(String hintName, Object value, boolean validateThrowException) {
        boolean valueSet;
        block7: {
            String key = this.hintToKey(hintName);
            boolean bl = valueSet = !hintName.equals(key);
            if (this.hasPrecedent(hintName)) {
                try {
                    valueSet |= this.setHintInternal(key, value, validateThrowException);
                }
                catch (RuntimeException rte) {
                    if (validateThrowException) {
                        if (rte instanceof IllegalArgumentException) {
                            throw rte;
                        }
                        if (rte instanceof ClassCastException) {
                            throw new IllegalArgumentException(_loc.get("bad-hint-value", key, value, rte.getMessage()).getMessage());
                        }
                        this.handleException(rte);
                        break block7;
                    }
                    this._fConfig.getContext().getConfiguration().getLog("openjpa.Runtime").warn(_loc.get("bad-hint-value", key, value, rte.getMessage()));
                }
            } else {
                valueSet = true;
            }
        }
        return valueSet;
    }

    protected String hintToKey(String key) {
        return key;
    }

    protected boolean hasPrecedent(String key) {
        return true;
    }

    protected void handleException(RuntimeException e) {
        throw e;
    }

    protected final boolean hintToSetter(Object target, String k, Object value) {
        if (target == null || k == null) {
            return false;
        }
        k = AbstractHintHandler.getSuffixOf(k);
        Method setter = Reflection.findSetter(target.getClass(), k, true);
        Class<?> paramType = setter.getParameterTypes()[0];
        if (Enum.class.isAssignableFrom(paramType) && value instanceof String) {
            String strValue = ((String)value).toUpperCase().replace('-', '_');
            value = Enum.valueOf(paramType, strValue);
        }
        Filters.hintToSetter(target, k, value);
        return true;
    }

    protected static String getPrefixOf(String key) {
        int firstDot = key == null ? -1 : key.indexOf(DOT);
        return firstDot != -1 ? key.substring(0, firstDot) : key;
    }

    protected static String getSuffixOf(String key) {
        int lastDot = key == null ? -1 : key.lastIndexOf(DOT);
        return lastDot != -1 ? key.substring(lastDot + 1) : key;
    }
}

