/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface QueryStatistics<T>
extends Serializable {
    public void recordExecution(T var1);

    public long getExecutionCount();

    public long getTotalExecutionCount();

    public long getExecutionCount(T var1);

    public long getTotalExecutionCount(T var1);

    public long getHitCount();

    public long getTotalHitCount();

    public long getHitCount(T var1);

    public long getTotalHitCount(T var1);

    public Date since();

    public Date start();

    public void reset();

    public void clear();

    public void dump(PrintStream var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Default<T>
    implements QueryStatistics<T> {
        private static final int ARRAY_SIZE = 2;
        private static final int READ = 0;
        private static final int HIT = 1;
        private long[] astat = new long[2];
        private long[] stat = new long[2];
        private Map<T, long[]> stats = new HashMap<T, long[]>();
        private Map<T, long[]> astats = new HashMap<T, long[]>();
        private Date start;
        private Date since = this.start = new Date();

        @Override
        public long getExecutionCount() {
            return this.stat[0];
        }

        @Override
        public long getTotalExecutionCount() {
            return this.astat[0];
        }

        @Override
        public long getExecutionCount(T query) {
            return this.getCount(this.stats, query, 0);
        }

        @Override
        public long getTotalExecutionCount(T query) {
            return this.getCount(this.astats, query, 0);
        }

        @Override
        public long getHitCount() {
            return this.stat[1];
        }

        @Override
        public long getTotalHitCount() {
            return this.astat[1];
        }

        @Override
        public long getHitCount(T query) {
            return this.getCount(this.stats, query, 1);
        }

        @Override
        public long getTotalHitCount(T query) {
            return this.getCount(this.astats, query, 1);
        }

        private long getCount(Map<T, long[]> target, T query, int i) {
            long[] row = target.get(query);
            return row == null ? 0L : row[i];
        }

        @Override
        public Date since() {
            return this.since;
        }

        @Override
        public Date start() {
            return this.start;
        }

        @Override
        public void reset() {
            this.stat = new long[2];
            this.stats.clear();
            this.since = new Date();
        }

        @Override
        public void clear() {
            this.astat = new long[2];
            this.stat = new long[2];
            this.stats = new HashMap<T, long[]>();
            this.astats = new HashMap<T, long[]>();
            this.since = this.start = new Date();
        }

        private void addSample(T query, int index) {
            int n = index;
            this.stat[n] = this.stat[n] + 1L;
            int n2 = index;
            this.astat[n2] = this.astat[n2] + 1L;
            this.addSample(this.stats, query, index);
            this.addSample(this.astats, query, index);
        }

        private void addSample(Map<T, long[]> target, T query, int i) {
            long[] row = target.get(query);
            if (row == null) {
                row = new long[2];
            }
            int n = i;
            row[n] = row[n] + 1L;
            target.put(query, row);
        }

        @Override
        public void recordExecution(T query) {
            boolean cached = this.astats.containsKey(query);
            this.addSample(query, 0);
            if (cached) {
                this.addSample(query, 1);
            }
        }

        @Override
        public void dump(PrintStream out) {
            String header = "Query Statistics starting from " + this.start;
            out.print(header);
            if (this.since == this.start) {
                out.println();
                out.println("Total Query Execution: " + this.toString(this.astat));
                out.println("\tTotal \t\tQuery");
            } else {
                out.println(" last reset on " + this.since);
                out.println("Total Query Execution since start " + this.toString(this.astat) + " since reset " + this.toString(this.stat));
                out.println("\tSince Start \tSince Reset \t\tQuery");
            }
            int i = 0;
            for (T key : this.stats.keySet()) {
                ++i;
                long[] arow = this.astats.get(key);
                if (this.since == this.start) {
                    out.println(i + ". \t" + this.toString(arow) + " \t" + key);
                    continue;
                }
                long[] row = this.stats.get(key);
                out.println(i + ". \t" + this.toString(arow) + " \t" + this.toString(row) + " \t\t" + key);
            }
        }

        long pct(long per, long cent) {
            if (cent <= 0L) {
                return 0L;
            }
            return 100L * per / cent;
        }

        String toString(long[] row) {
            return row[0] + ":" + row[1] + "(" + this.pct(row[1], row[0]) + "%)";
        }
    }
}

