/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.ConstantExpression;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.TrimSpec;
import org.apache.openjpa.persistence.query.UnaryFunctionalOperator;
import org.apache.openjpa.persistence.query.UnaryOperatorExpression;
import org.apache.openjpa.persistence.query.Visitable;

public class TrimExpression
extends UnaryOperatorExpression {
    private final Expression _trimChar;
    private final TrimSpec _trimSpec;
    private static final String DEFAULT_TRIM_CHAR = "' '";
    private static final String DEFAULT_TRIM_SPEC = "";

    public TrimExpression(Expression op, char ch, TrimSpec spec) {
        super(op, UnaryFunctionalOperator.TRIM);
        this._trimChar = new ConstantExpression(Character.valueOf(ch));
        this._trimSpec = spec;
    }

    public TrimExpression(Expression op, Expression ch, TrimSpec spec) {
        super(op, UnaryFunctionalOperator.TRIM);
        this._trimChar = ch;
        this._trimSpec = spec;
    }

    public String asExpression(AliasContext ctx) {
        String trimChar = this._trimChar == null ? DEFAULT_TRIM_CHAR : ((Visitable)((Object)this._trimChar)).asExpression(ctx);
        String trimSpec = this._trimSpec == null ? DEFAULT_TRIM_SPEC : this._trimSpec.toString();
        return this._op.toString() + "(" + trimSpec + " " + trimChar + " FROM " + ((Visitable)((Object)this._e)).asExpression(ctx) + ")";
    }
}

