/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.CacheDistributionPolicy;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCacheMode;
import org.apache.openjpa.datacache.DataCachePCDataGenerator;
import org.apache.openjpa.datacache.DataCacheScheduler;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.ImplHelper;
import serp.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCacheManagerImpl
implements Closeable,
DataCacheManager {
    private OpenJPAConfiguration _conf;
    private DataCache _cache = null;
    private QueryCache _queryCache = null;
    private DataCachePCDataGenerator _pcGenerator = null;
    private DataCacheScheduler _scheduler = null;
    private CacheDistributionPolicy _policy = new CacheDistributionPolicy.Default();
    private Set<String> _excludedTypes;
    private Set<String> _includedTypes;

    @Override
    public void initialize(OpenJPAConfiguration conf, ObjectValue dataCache, ObjectValue queryCache) {
        this._conf = conf;
        this._cache = (DataCache)dataCache.instantiate(DataCache.class, conf);
        if (this._cache == null) {
            return;
        }
        if (conf.getDynamicDataStructs()) {
            this._pcGenerator = new DataCachePCDataGenerator(conf);
        }
        this._scheduler = new DataCacheScheduler(conf);
        this._cache.initialize(this);
        this._queryCache = (QueryCache)queryCache.instantiate(QueryCache.class, conf);
        if (this._queryCache != null) {
            this._queryCache.initialize(this);
        }
    }

    @Override
    public DataCache getSystemDataCache() {
        return this.getDataCache(null, false);
    }

    @Override
    public DataCache getDataCache(String name) {
        return this.getDataCache(name, false);
    }

    @Override
    public DataCache getDataCache(String name, boolean create) {
        if (name == null || this._cache != null && name.equals(this._cache.getName())) {
            return this._cache;
        }
        if (this._cache != null) {
            return this._cache.getPartition(name, create);
        }
        return null;
    }

    @Override
    public QueryCache getSystemQueryCache() {
        return this._queryCache;
    }

    @Override
    public DataCachePCDataGenerator getPCDataGenerator() {
        return this._pcGenerator;
    }

    @Override
    public DataCacheScheduler getDataCacheScheduler() {
        return this._scheduler;
    }

    @Override
    public void close() {
        ImplHelper.close(this._cache);
        ImplHelper.close(this._queryCache);
        if (this._scheduler != null) {
            this._scheduler.stop();
        }
    }

    @Override
    public DataCache selectCache(OpenJPAStateManager sm) {
        if (sm == null || !this.isCachable(sm.getMetaData())) {
            return null;
        }
        String name = this._policy.selectCache(sm, null);
        return name == null ? null : this.getDataCache(name);
    }

    @Override
    public CacheDistributionPolicy getDistributionPolicy() {
        return this._policy;
    }

    public void setDistributionPolicy(CacheDistributionPolicy policy) {
        this._policy = policy;
    }

    public boolean isCachable(ClassMetaData meta) {
        Boolean isCachable = this.isCacheableByPlugin(meta);
        if (isCachable == null && (isCachable = this.isCacheableByMode(meta)) == null) {
            isCachable = this.isCacheableByType(meta);
        }
        return isCachable;
    }

    private Boolean isCacheableByMode(ClassMetaData meta) {
        String mode = this._conf.getDataCacheMode();
        if (DataCacheMode.ALL.toString().equalsIgnoreCase(mode)) {
            return true;
        }
        if (DataCacheMode.NONE.toString().equalsIgnoreCase(mode)) {
            return false;
        }
        if (DataCacheMode.ENABLE_SELECTIVE.toString().equalsIgnoreCase(mode)) {
            return Boolean.TRUE.equals(meta.getCacheEnabled());
        }
        if (DataCacheMode.DISABLE_SELECTIVE.toString().equalsIgnoreCase(mode)) {
            return !Boolean.FALSE.equals(meta.getCacheEnabled());
        }
        return null;
    }

    private Boolean isCacheableByType(ClassMetaData meta) {
        return meta.getDataCacheName() != null;
    }

    private Boolean isCacheableByPlugin(ClassMetaData meta) {
        String className = meta.getDescribedType().getName();
        if (this._excludedTypes != null && this._excludedTypes.contains(className)) {
            return Boolean.FALSE;
        }
        if (this._includedTypes != null && this._includedTypes.contains(className)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Set<String> getExcludedTypes() {
        return this._excludedTypes;
    }

    @Override
    public void setExcludedTypes(String types) {
        this._excludedTypes = this.parseNames(types);
    }

    public Set<String> getIncludedTypes() {
        return this._excludedTypes;
    }

    @Override
    public void setIncludedTypes(String types) {
        this._includedTypes = this.parseNames(types);
    }

    private Set<String> parseNames(String types) {
        if (StringUtils.isEmpty(types)) {
            return Collections.emptySet();
        }
        String[] names = Strings.split(types, ";", 0);
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(names));
        return Collections.unmodifiableSet(set);
    }
}

