/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import java.util.LinkedList;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.openjpa.ee.AbstractManagedRuntime;
import org.apache.openjpa.ee.InvocationManagedRuntime;
import org.apache.openjpa.ee.JNDIManagedRuntime;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.ee.SunOneManagedRuntime;
import org.apache.openjpa.ee.WASManagedRuntime;
import org.apache.openjpa.ee.WASRegistryManagedRuntime;
import org.apache.openjpa.ee.WLSManagedRuntime;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InvalidStateException;

public class AutomaticManagedRuntime
extends AbstractManagedRuntime
implements ManagedRuntime,
Configurable {
    private static final String[] JNDI_LOCS = new String[]{"javax.transaction.TransactionManager", "java:/TransactionManager", "java:/DefaultDomain/TransactionManager", "java:comp/pm/TransactionManager", "java:comp/TransactionManager", "java:pm/TransactionManager", "java:appserver/TransactionManager"};
    private static final String[] METHODS = new String[]{"com.arjuna.jta.JTA_TransactionManager.transactionManager", "com.bluestone.jta.SaTransactionManagerFactory.SaGetTransactionManager", "org.openejb.OpenEJB.getTransactionManager", "com.sun.jts.jta.TransactionManagerImpl.getTransactionManagerImpl", "com.inprise.visitransact.jta.TransactionManagerImpl.getTransactionManagerImpl"};
    private static final ManagedRuntime REGISTRY;
    private static final WLSManagedRuntime WLS;
    private static final SunOneManagedRuntime SUNONE;
    private static final WASManagedRuntime WAS;
    private static final WASRegistryManagedRuntime WAS_REG;
    private static Localizer _loc;
    private Configuration _conf = null;
    private ManagedRuntime _runtime = null;

    public TransactionManager getTransactionManager() throws Exception {
        if (this._runtime != null) {
            return this._runtime.getTransactionManager();
        }
        LinkedList<Throwable> errors = new LinkedList<Throwable>();
        TransactionManager tm = null;
        if (WAS_REG != null) {
            try {
                tm = WAS_REG.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = WAS_REG;
                return tm;
            }
        }
        if (REGISTRY != null) {
            try {
                tm = REGISTRY.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = REGISTRY;
                return tm;
            }
        }
        if (WLS != null) {
            try {
                tm = WLS.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = WLS;
                return tm;
            }
        }
        if (WAS != null) {
            try {
                WAS.setConfiguration(this._conf);
                WAS.startConfiguration();
                WAS.endConfiguration();
                tm = WAS.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = WAS;
                return tm;
            }
        }
        JNDIManagedRuntime jmr = new JNDIManagedRuntime();
        for (int i = 0; i < JNDI_LOCS.length; ++i) {
            jmr.setTransactionManagerName(JNDI_LOCS[i]);
            try {
                tm = jmr.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm == null) continue;
            this._runtime = jmr;
            return tm;
        }
        InvocationManagedRuntime imr = new InvocationManagedRuntime();
        for (int i = 0; i < METHODS.length; ++i) {
            imr.setConfiguration(this._conf);
            imr.setTransactionManagerMethod(METHODS[i]);
            try {
                tm = imr.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm == null) continue;
            this._runtime = imr;
            return tm;
        }
        if (SUNONE != null) {
            try {
                tm = SUNONE.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = SUNONE;
                return tm;
            }
        }
        Throwable[] t = errors.toArray(new Throwable[errors.size()]);
        throw new InvalidStateException(_loc.get("tm-not-found")).setFatal(true).setNestedThrowables(t);
    }

    public void setConfiguration(Configuration conf) {
        this._conf = conf;
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
    }

    public void setRollbackOnly(Throwable cause) throws Exception {
        if (this._runtime == null) {
            this.getTransactionManager();
        }
        if (this._runtime != null) {
            this._runtime.setRollbackOnly(cause);
        }
    }

    public Throwable getRollbackCause() throws Exception {
        if (this._runtime == null) {
            this.getTransactionManager();
        }
        if (this._runtime != null) {
            return this._runtime.getRollbackCause();
        }
        return null;
    }

    public Object getTransactionKey() throws Exception, SystemException {
        if (this._runtime == null) {
            this.getTransactionManager();
        }
        if (this._runtime != null) {
            return this._runtime.getTransactionKey();
        }
        return null;
    }

    public void doNonTransactionalWork(Runnable runnable) throws NotSupportedException {
        try {
            this.getTransactionManager();
        }
        catch (Exception e) {
            NotSupportedException nse = new NotSupportedException(_loc.get("tm-unavailable", this._runtime).getMessage());
            nse.initCause(e);
            throw nse;
        }
        this._runtime.doNonTransactionalWork(runnable);
    }

    static {
        _loc = Localizer.forPackage(AutomaticManagedRuntime.class);
        ManagedRuntime mr = null;
        mr = null;
        try {
            mr = (ManagedRuntime)Class.forName("org.apache.openjpa.ee.RegistryManagedRuntime").newInstance();
        }
        catch (Throwable t) {
            // empty catch block
        }
        REGISTRY = mr;
        mr = null;
        try {
            mr = new WLSManagedRuntime();
        }
        catch (Throwable t) {
            // empty catch block
        }
        WLS = (WLSManagedRuntime)mr;
        mr = null;
        try {
            mr = new SunOneManagedRuntime();
        }
        catch (Throwable t) {
            // empty catch block
        }
        SUNONE = (SunOneManagedRuntime)mr;
        mr = null;
        try {
            mr = new WASManagedRuntime();
        }
        catch (Throwable t) {
            // empty catch block
        }
        WAS = (WASManagedRuntime)mr;
        mr = null;
        try {
            ClassLoader cl = AutomaticManagedRuntime.class.getClassLoader();
            Class<?> mrClass = J2DoPrivHelper.getForNameAction(WASRegistryManagedRuntime.class.getName(), true, cl).run();
            mr = (ManagedRuntime)J2DoPrivHelper.newInstanceAction(mrClass).run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        WAS_REG = (WASRegistryManagedRuntime)mr;
    }
}

