/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.UnaryOp;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;

class Count
extends UnaryOp {
    public Count(Val val) {
        super(val);
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return this.initializeValue(sel, ctx, 4);
    }

    protected Class getType(Class c) {
        return Long.TYPE;
    }

    protected String getOperator() {
        return "COUNT";
    }

    public boolean isAggregate() {
        return true;
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        String s;
        super.appendTo(sel, ctx, state, sql2, index);
        if (ctx.store.getDBDictionary().useWildCardForCount && state.joins.isEmpty() && (s = sql2.getSQL()).startsWith("COUNT(") && s.endsWith(")")) {
            sql2.replaceSqlString("COUNT(".length(), s.length() - 1, "*");
        }
    }
}

