/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class Services {
    private static final String PREFIX = "META-INF/services/";

    public static String[] getImplementors(Class serviceClass) {
        return Services.getImplementors(serviceClass, null);
    }

    public static String[] getImplementors(Class serviceClass, ClassLoader loader) {
        return Services.getImplementors(serviceClass.getName(), loader);
    }

    public static String[] getImplementors(String serviceName) {
        return Services.getImplementors(serviceName, null);
    }

    public static String[] getImplementors(String serviceName, ClassLoader loader) {
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        try {
            TreeSet resourceList = new TreeSet();
            Enumeration<URL> resources = AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(loader, PREFIX + serviceName));
            while (resources.hasMoreElements()) {
                Services.addResources(resources.nextElement(), resourceList);
            }
            return resourceList.toArray(new String[resourceList.size()]);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addResources(URL url, Set set) throws IOException {
        InputStream in = null;
        BufferedReader reader = null;
        URLConnection urlCon = null;
        try {
            String line;
            urlCon = url.openConnection();
            urlCon.setUseCaches(false);
            in = urlCon.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                String next;
                StringTokenizer tok;
                if (line.trim().startsWith("#") || line.trim().length() == 0 || !(tok = new StringTokenizer(line, "# \t")).hasMoreTokens() || (next = tok.nextToken()) == null || (next = next.trim()).length() <= 0 || next.startsWith("#")) continue;
                set.add(next);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {}
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
    }

    public static Class[] getImplementorClasses(Class serviceClass) {
        return Services.getImplementorClasses(serviceClass.getName(), null);
    }

    public static Class[] getImplementorClasses(Class serviceClass, ClassLoader loader) {
        HashSet<Class> invalid = new HashSet<Class>();
        Class[] classes = Services.getImplementorClasses(serviceClass.getName(), loader);
        for (int i = 0; i < classes.length; ++i) {
            if (serviceClass.isAssignableFrom(classes[i])) continue;
            invalid.add(classes[i]);
        }
        if (invalid.size() != 0) {
            ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(classes));
            list.removeAll(invalid);
            return list.toArray(new Class[list.size()]);
        }
        return classes;
    }

    public static Class[] getImplementorClasses(String serviceName) {
        return Services.getImplementorClasses(serviceName, null);
    }

    public static Class[] getImplementorClasses(String serviceName, ClassLoader loader) {
        try {
            return Services.getImplementorClasses(serviceName, loader, true);
        }
        catch (Exception cnfe) {
            return new Class[0];
        }
    }

    public static Class[] getImplementorClasses(String serviceName, ClassLoader loader, boolean skipMissing) throws ClassNotFoundException {
        String[] names;
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        if ((names = Services.getImplementors(serviceName, loader)) == null) {
            return new Class[0];
        }
        ArrayList classes = new ArrayList(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                classes.add(Class.forName(names[i], false, loader));
                continue;
            }
            catch (ClassNotFoundException e) {
                if (skipMissing) continue;
                throw e;
            }
            catch (UnsupportedClassVersionError ecve) {
                if (skipMissing) continue;
                throw ecve;
            }
            catch (LinkageError le) {
                if (skipMissing) continue;
                throw le;
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }
}

