/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.PathImpl;
import org.apache.openjpa.persistence.meta.Members;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FetchPathImpl<Z, X>
extends PathImpl<Z, X>
implements Fetch<Z, X> {
    protected Set<Fetch<?, ?>> _fetches;
    protected JoinType joinType;

    FetchPathImpl(FetchParent<?, Z> parent, Members.Member<? super Z, X> member) {
        this(parent, member, JoinType.INNER);
    }

    FetchPathImpl(FetchParent<?, Z> parent, Members.Member<? super Z, X> member, JoinType type) {
        super((PathImpl)((Object)parent), member, member.getJavaType());
        this.joinType = type;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public Attribute<Z, X> getAttribute() {
        return this._member;
    }

    @Override
    public FetchParent<?, Z> getParent() {
        return (FetchParent)((Object)this._parent);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc) {
        return this.addFetch((Members.Member)((Object)assoc), JoinType.INNER);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc) {
        return this.addFetch((Members.Member)((Object)assoc), JoinType.INNER);
    }

    @Override
    public <X, Y> Fetch<X, Y> fetch(String assocName) {
        return this.fetch(assocName, JoinType.INNER);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc, JoinType jt) {
        return this.addFetch((Members.Member)((Object)assoc), jt);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc, JoinType jt) {
        return this.addFetch((Members.Member)((Object)assoc), jt);
    }

    @Override
    public <X, Y> Fetch<X, Y> fetch(String assocName, JoinType jt) {
        Attribute assoc = ((ManagedType)this._member.getType()).getAttribute(assocName);
        return this.addFetch((Members.Member)assoc, jt);
    }

    @Override
    public Set<Fetch<X, ?>> getFetches() {
        HashSet result = new HashSet();
        for (Fetch<?, ?> f : this._fetches) {
            result.add(f);
        }
        return result;
    }

    private <X, Y> Fetch<X, Y> addFetch(Members.Member<? super X, Y> member, JoinType jt) {
        FetchPathImpl<? super X, Y> fetch = new FetchPathImpl<X, Y>(this, member, jt);
        if (this._fetches == null) {
            this._fetches = new HashSet();
        }
        this._fetches.add(fetch);
        return fetch;
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        return super.asValue(q).insert(0, " " + (Object)((Object)this.joinType) + " JOIN FETCH ");
    }
}

