/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.util.Comparator;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.JDBCOrder;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.MetaDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCRelatedFieldOrder
implements JDBCOrder {
    private static final Localizer _loc = Localizer.forPackage(JDBCRelatedFieldOrder.class);
    private final FieldMapping _fm;
    private final boolean _asc;

    public JDBCRelatedFieldOrder(FieldMapping owner, FieldMapping rel, boolean asc) {
        if (!rel.isInDefaultFetchGroup() && !rel.isPrimaryKey()) {
            throw new MetaDataException(_loc.get("nondfg-field-orderable", owner, rel.getName()));
        }
        this._fm = rel;
        this._asc = asc;
    }

    @Override
    public String getName() {
        return this._fm.getName();
    }

    @Override
    public DBIdentifier getIdentifier() {
        return DBIdentifier.newColumn(this._fm.getName());
    }

    @Override
    public boolean isAscending() {
        return this._asc;
    }

    @Override
    public Comparator<?> getComparator() {
        return null;
    }

    @Override
    public boolean isInRelation() {
        return true;
    }

    @Override
    public void order(Select sel, ClassMapping elem, Joins joins) {
        FieldMapping fm = this._fm;
        if (elem != null) {
            fm = elem.getFieldMapping(this._fm.getIndex());
        }
        sel.orderBy(fm.getColumns(), this._asc, joins, false);
    }
}

