/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationFactory {
    private static Instrumentation _inst;
    private static boolean _dynamicallyInstall;
    private static final String _name;
    private static final Localizer _loc;

    public static void setInstrumentation(Instrumentation inst) {
        _inst = inst;
    }

    public static synchronized void setDynamicallyInstallAgent(boolean val) {
        _dynamicallyInstall = val;
    }

    public static synchronized Instrumentation getInstrumentation(final Log log) {
        if (_inst != null || !_dynamicallyInstall) {
            return _inst;
        }
        if (JavaVersions.VERSION < 6) {
            return null;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (!InstrumentationFactory.class.getClassLoader().equals(ClassLoader.getSystemClassLoader())) {
                        return null;
                    }
                }
                catch (Throwable t) {
                    return null;
                }
                File toolsJar = InstrumentationFactory.findToolsJar(log);
                if (toolsJar == null) {
                    return null;
                }
                Class vmClass = InstrumentationFactory.loadVMClass(toolsJar, log);
                if (vmClass == null) {
                    return null;
                }
                String agentPath = InstrumentationFactory.getAgentJar(log);
                if (agentPath == null) {
                    return null;
                }
                InstrumentationFactory.loadAgent(log, agentPath, vmClass);
                return null;
            }
        });
        return _inst;
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        InstrumentationFactory.setInstrumentation(inst);
    }

    private static String createAgentJar() throws IOException {
        File file = File.createTempFile(InstrumentationFactory.class.getName(), ".jar");
        file.deleteOnExit();
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(file));
        zout.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(zout));
        writer.println("Agent-Class: " + InstrumentationFactory.class.getName());
        writer.println("Can-Redefine-Classes: true");
        writer.println("Can-Retransform-Classes: true");
        writer.close();
        return file.getAbsolutePath();
    }

    private static File findToolsJar(Log log) {
        String absPath;
        String javaHome = System.getProperty("java.home");
        File javaHomeFile = new File(javaHome);
        File toolsJarFile = new File(javaHomeFile, "lib" + File.separator + "tools.jar");
        if (!toolsJarFile.exists() && (absPath = javaHomeFile.getAbsolutePath()).endsWith(File.separator + "jre")) {
            javaHomeFile = javaHomeFile.getParentFile();
            toolsJarFile = new File(javaHomeFile, "lib" + File.separator + "tools.jar");
        }
        if (!toolsJarFile.exists()) {
            String toolsJarPath = toolsJarFile.getAbsolutePath();
            if (log.isTraceEnabled()) {
                log.trace(_name + ".findToolsJar() -- couldn't find " + toolsJarPath);
            }
            return null;
        }
        return toolsJarFile;
    }

    private static String getAgentJar(Log log) {
        String agentJar;
        URL loc;
        File agentJarFile = null;
        CodeSource cs = InstrumentationFactory.class.getProtectionDomain().getCodeSource();
        if (cs != null && (loc = cs.getLocation()) != null) {
            agentJarFile = new File(loc.getFile());
        }
        boolean createJar = false;
        if (cs == null || agentJarFile == null || agentJarFile.isDirectory()) {
            createJar = true;
        } else if (!InstrumentationFactory.validateAgentJarManifest(agentJarFile, log, _name)) {
            createJar = true;
        }
        if (createJar) {
            try {
                agentJar = InstrumentationFactory.createAgentJar();
                if (log.isInfoEnabled()) {
                    log.info(_loc.get("temp-file-creation", agentJar));
                }
            }
            catch (IOException ioe) {
                if (log.isTraceEnabled()) {
                    log.trace(_name + ".getAgentJar() caught unexpected " + "exception.", ioe);
                }
                agentJar = null;
            }
        } else {
            agentJar = agentJarFile.getAbsolutePath();
        }
        return agentJar;
    }

    private static void loadAgent(Log log, String agentJar, Class<?> vmClass) {
        block3: {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String pid = runtime.getName();
                if (pid.indexOf("@") != -1) {
                    pid = pid.substring(0, pid.indexOf("@"));
                }
                Object vm = vmClass.getMethod("attach", String.class).invoke(null, (Object[])new String[]{pid});
                vmClass.getMethod("loadAgent", String.class).invoke(vm, agentJar);
                vmClass.getMethod("detach", new Class[0]).invoke(vm, new Object[0]);
            }
            catch (Throwable t) {
                if (!log.isTraceEnabled()) break block3;
                log.trace(_name + ".loadAgent() caught an exception. Message: " + t.getMessage());
            }
        }
    }

    private static Class<?> loadVMClass(File toolsJar, Log log) {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{toolsJar.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
            return loader.loadClass("com.sun.tools.attach.VirtualMachine");
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace(_name + ".loadVMClass() failed to load the VirtualMachine class");
            }
            return null;
        }
    }

    private static boolean validateAgentJarManifest(File agentJarFile, Log log, String agentClassName) {
        block4: {
            try {
                JarFile jar = new JarFile(agentJarFile);
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                    return false;
                }
                Attributes attributes = manifest.getMainAttributes();
                String ac = attributes.getValue("Agent-Class");
                if (ac != null && ac.equals(agentClassName)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block4;
                log.trace(_name + ".validateAgentJarManifest() caught unexpected " + "exception " + e.getMessage());
            }
        }
        return false;
    }

    static {
        _dynamicallyInstall = true;
        _name = InstrumentationFactory.class.getName();
        _loc = Localizer.forPackage(InstrumentationFactory.class);
    }
}

