/*
 * Decompiled with CFR 0.152.
 */
package serp.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import serp.util.Numbers;

public class Strings {
    private static final Object[][] _codes = new Object[][]{{Byte.TYPE, "byte", "B"}, {Character.TYPE, "char", "C"}, {Double.TYPE, "double", "D"}, {Float.TYPE, "float", "F"}, {Integer.TYPE, "int", "I"}, {Long.TYPE, "long", "J"}, {Short.TYPE, "short", "S"}, {Boolean.TYPE, "boolean", "Z"}, {Void.TYPE, "void", "V"}};
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static String replace(String str, String from, String to) {
        Object[] split = Strings.split(str, from, Integer.MAX_VALUE);
        return Strings.join(split, to);
    }

    public static String[] split(String str, String token, int max) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        if (token == null || token.length() == 0) {
            throw new IllegalArgumentException("token: [" + token + "]");
        }
        LinkedList<String> ret = new LinkedList<String>();
        int start = 0;
        int split = 0;
        while (split != -1) {
            split = str.indexOf(token, start);
            if (split == -1 && start >= str.length()) {
                ret.add("");
                continue;
            }
            if (split == -1) {
                ret.add(str.substring(start));
                continue;
            }
            ret.add(str.substring(start, split));
            start = split + token.length();
        }
        if (max == 0) {
            while (ret.getLast().equals("")) {
                ret.removeLast();
            }
        } else if (max > 0 && ret.size() > max) {
            StringBuffer buf = new StringBuffer(ret.removeLast().toString());
            while (ret.size() >= max) {
                buf.insert(0, token);
                buf.insert(0, ret.removeLast());
            }
            ret.add(buf.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String join(Object[] strings, String token) {
        if (strings == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(20 * strings.length);
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                buf.append(token);
            }
            if (strings[i] == null) continue;
            buf.append(strings[i]);
        }
        return buf.toString();
    }

    public static Class toClass(String str, ClassLoader loader) {
        return Strings.toClass(str, false, loader);
    }

    public static Class toClass(String str, boolean resolve, ClassLoader loader) {
        if (str == null) {
            throw new NullPointerException("str == null");
        }
        int dims = 0;
        while (str.endsWith("[]")) {
            ++dims;
            str = str.substring(0, str.length() - 2);
        }
        boolean primitive = false;
        if (str.indexOf(46) == -1) {
            for (int i = 0; !primitive && i < _codes.length; ++i) {
                if (!_codes[i][1].equals(str)) continue;
                if (dims == 0) {
                    return (Class)_codes[i][0];
                }
                str = (String)_codes[i][2];
                primitive = true;
            }
        }
        if (dims > 0) {
            int size = str.length() + dims;
            if (!primitive) {
                size += 2;
            }
            StringBuffer buf = new StringBuffer(size);
            for (int i = 0; i < dims; ++i) {
                buf.append('[');
            }
            if (!primitive) {
                buf.append('L');
            }
            buf.append(str);
            if (!primitive) {
                buf.append(';');
            }
            str = buf.toString();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return Class.forName(str, resolve, loader);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.toString());
        }
    }

    public static String getClassName(Class cls) {
        return cls == null ? null : Strings.getClassName(cls.getName());
    }

    public static String getClassName(String fullName) {
        int i;
        if (fullName == null) {
            return null;
        }
        int dims = 0;
        for (i = 0; i < fullName.length(); ++i) {
            if (fullName.charAt(i) == '[') continue;
            dims = i;
            break;
        }
        if (dims > 0) {
            fullName = fullName.substring(dims);
        }
        for (i = 0; i < _codes.length; ++i) {
            if (!_codes[i][2].equals(fullName)) continue;
            fullName = (String)_codes[i][1];
            break;
        }
        fullName = fullName.substring(fullName.lastIndexOf(46) + 1);
        for (i = 0; i < dims; ++i) {
            fullName = fullName + "[]";
        }
        return fullName;
    }

    public static String getPackageName(Class cls) {
        return cls == null ? null : Strings.getPackageName(cls.getName());
    }

    public static String getPackageName(String fullName) {
        if (fullName == null) {
            return null;
        }
        int dotIdx = fullName.lastIndexOf(46);
        return dotIdx == -1 ? "" : fullName.substring(0, dotIdx);
    }

    public static Object parse(String val, Class type) {
        if (!Strings.canParse(type)) {
            throw new IllegalArgumentException("invalid type: " + type.getName());
        }
        if (val == null) {
            if (!type.isPrimitive()) {
                return null;
            }
            if (type == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (type == Byte.TYPE) {
                return new Byte(0);
            }
            if (type == Character.TYPE) {
                return new Character('\u0000');
            }
            if (type == Double.TYPE) {
                return new Double(0.0);
            }
            if (type == Float.TYPE) {
                return new Float(0.0f);
            }
            if (type == Integer.TYPE) {
                return Numbers.valueOf(0);
            }
            if (type == Long.TYPE) {
                return Numbers.valueOf(0L);
            }
            if (type == Short.TYPE) {
                return new Short(0);
            }
            throw new IllegalStateException("invalid type: " + type);
        }
        if (type == Boolean.TYPE || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Strings.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.valueOf(val);
        }
        if (type == Byte.TYPE || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Strings.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.valueOf(val);
        }
        if (type == Character.TYPE || type == (class$java$lang$Character == null ? (class$java$lang$Character = Strings.class$("java.lang.Character")) : class$java$lang$Character)) {
            if (val.length() == 0) {
                return new Character('\u0000');
            }
            if (val.length() == 1) {
                return new Character(val.charAt(0));
            }
            throw new IllegalArgumentException("'" + val + "' is longer than " + "one character.");
        }
        if (type == Double.TYPE || type == (class$java$lang$Double == null ? (class$java$lang$Double = Strings.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.valueOf(val);
        }
        if (type == Float.TYPE || type == (class$java$lang$Float == null ? (class$java$lang$Float = Strings.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.valueOf(val);
        }
        if (type == Integer.TYPE || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Strings.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.valueOf(val);
        }
        if (type == Long.TYPE || type == (class$java$lang$Long == null ? (class$java$lang$Long = Strings.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.valueOf(val);
        }
        if (type == Short.TYPE || type == (class$java$lang$Short == null ? (class$java$lang$Short = Strings.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.valueOf(val);
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = Strings.class$("java.lang.String")) : class$java$lang$String)) {
            return val;
        }
        if (type == (class$java$util$Date == null ? (class$java$util$Date = Strings.class$("java.util.Date")) : class$java$util$Date)) {
            return new Date(val);
        }
        if (type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = Strings.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(val);
        }
        if (type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Strings.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(val);
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static boolean canParse(Class type) {
        return type.isPrimitive() || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Strings.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Strings.class$("java.lang.Byte")) : class$java$lang$Byte) || type == (class$java$lang$Character == null ? (class$java$lang$Character = Strings.class$("java.lang.Character")) : class$java$lang$Character) || type == (class$java$lang$Short == null ? (class$java$lang$Short = Strings.class$("java.lang.Short")) : class$java$lang$Short) || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Strings.class$("java.lang.Integer")) : class$java$lang$Integer) || type == (class$java$lang$Long == null ? (class$java$lang$Long = Strings.class$("java.lang.Long")) : class$java$lang$Long) || type == (class$java$lang$Float == null ? (class$java$lang$Float = Strings.class$("java.lang.Float")) : class$java$lang$Float) || type == (class$java$lang$Double == null ? (class$java$lang$Double = Strings.class$("java.lang.Double")) : class$java$lang$Double) || type == (class$java$lang$String == null ? (class$java$lang$String = Strings.class$("java.lang.String")) : class$java$lang$String) || type == (class$java$util$Date == null ? (class$java$util$Date = Strings.class$("java.util.Date")) : class$java$util$Date) || type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = Strings.class$("java.math.BigInteger")) : class$java$math$BigInteger) || type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Strings.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

