/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Map;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;

public abstract class DistributedResultSet
implements ResultSet {
    static final Constructor<DistributedResultSet> concreteImpl;
    private LinkedList<ResultSet> comps = new LinkedList();
    private ResultSet current;
    private int cursor = -1;

    public static DistributedResultSet newInstance() {
        return ConcreteClassGenerator.newInstance(concreteImpl, new Object[0]);
    }

    public void add(ResultSet rs) {
        try {
            if (rs.first()) {
                this.comps.add(rs);
                rs.beforeFirst();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean absolute(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws SQLException {
        this.current = null;
        this.cursor = this.comps.size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.current = null;
        this.cursor = -1;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.current.cancelRowUpdates();
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (ResultSet rs : this.comps) {
            rs.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        for (ResultSet rs : this.comps) {
            rs.close();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int findColumn(String arg0) throws SQLException {
        return this.current.findColumn(arg0);
    }

    @Override
    public boolean first() throws SQLException {
        if (this.comps.isEmpty()) {
            return false;
        }
        this.cursor = 0;
        this.current = this.comps.getFirst();
        return true;
    }

    @Override
    public Array getArray(int arg0) throws SQLException {
        return this.current.getArray(arg0);
    }

    @Override
    public Array getArray(String arg0) throws SQLException {
        return this.current.getArray(arg0);
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        return this.current.getAsciiStream(arg0);
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        return this.current.getAsciiStream(arg0);
    }

    @Override
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        return this.current.getBigDecimal(arg0);
    }

    @Override
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        return this.current.getBigDecimal(arg0);
    }

    @Override
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        return this.current.getBigDecimal(arg0, arg1);
    }

    @Override
    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        return this.current.getBigDecimal(arg0, arg1);
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        return this.current.getBinaryStream(arg0);
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        return this.current.getBinaryStream(arg0);
    }

    @Override
    public Blob getBlob(int arg0) throws SQLException {
        return this.current.getBlob(arg0);
    }

    @Override
    public Blob getBlob(String arg0) throws SQLException {
        return this.current.getBlob(arg0);
    }

    @Override
    public boolean getBoolean(int arg0) throws SQLException {
        return this.current.getBoolean(arg0);
    }

    @Override
    public boolean getBoolean(String arg0) throws SQLException {
        return this.current.getBoolean(arg0);
    }

    @Override
    public byte getByte(int arg0) throws SQLException {
        return this.current.getByte(arg0);
    }

    @Override
    public byte getByte(String arg0) throws SQLException {
        return this.current.getByte(arg0);
    }

    @Override
    public byte[] getBytes(int arg0) throws SQLException {
        return this.current.getBytes(arg0);
    }

    @Override
    public byte[] getBytes(String arg0) throws SQLException {
        return this.current.getBytes(arg0);
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        return this.current.getCharacterStream(arg0);
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        return this.current.getCharacterStream(arg0);
    }

    @Override
    public Clob getClob(int arg0) throws SQLException {
        return this.current.getClob(arg0);
    }

    @Override
    public Clob getClob(String arg0) throws SQLException {
        return this.current.getClob(arg0);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.current.getConcurrency();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.current.getCursorName();
    }

    @Override
    public Date getDate(int arg0) throws SQLException {
        return this.current.getDate(arg0);
    }

    @Override
    public Date getDate(String arg0) throws SQLException {
        return this.current.getDate(arg0);
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        return this.current.getDate(arg0, arg1);
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        return this.current.getDate(arg0, arg1);
    }

    @Override
    public double getDouble(int arg0) throws SQLException {
        return this.current.getDouble(arg0);
    }

    @Override
    public double getDouble(String arg0) throws SQLException {
        return this.current.getDouble(arg0);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.current.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.current.getFetchSize();
    }

    @Override
    public float getFloat(int arg0) throws SQLException {
        return this.current.getFloat(arg0);
    }

    @Override
    public float getFloat(String arg0) throws SQLException {
        return this.current.getFloat(arg0);
    }

    @Override
    public int getInt(int arg0) throws SQLException {
        return this.current.getInt(arg0);
    }

    @Override
    public int getInt(String arg0) throws SQLException {
        return this.current.getInt(arg0);
    }

    @Override
    public long getLong(int arg0) throws SQLException {
        return this.current.getLong(arg0);
    }

    @Override
    public long getLong(String arg0) throws SQLException {
        return this.current.getLong(arg0);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.current.getMetaData();
    }

    @Override
    public Object getObject(int arg0) throws SQLException {
        return this.current.getObject(arg0);
    }

    @Override
    public Object getObject(String arg0) throws SQLException {
        return this.current.getObject(arg0);
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        return this.current.getObject(arg0, arg1);
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        return this.current.getObject(arg0, arg1);
    }

    @Override
    public Ref getRef(int arg0) throws SQLException {
        return this.current.getRef(arg0);
    }

    @Override
    public Ref getRef(String arg0) throws SQLException {
        return this.current.getRef(arg0);
    }

    @Override
    public int getRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int arg0) throws SQLException {
        return this.current.getShort(arg0);
    }

    @Override
    public short getShort(String arg0) throws SQLException {
        return this.current.getShort(arg0);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.current.getStatement();
    }

    @Override
    public String getString(int arg0) throws SQLException {
        return this.current.getString(arg0);
    }

    @Override
    public String getString(String arg0) throws SQLException {
        return this.current.getString(arg0);
    }

    @Override
    public Time getTime(int arg0) throws SQLException {
        return this.current.getTime(arg0);
    }

    @Override
    public Time getTime(String arg0) throws SQLException {
        return this.current.getTime(arg0);
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        return this.current.getTime(arg0, arg1);
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        return this.current.getTime(arg0, arg1);
    }

    @Override
    public Timestamp getTimestamp(int arg0) throws SQLException {
        return this.current.getTimestamp(arg0);
    }

    @Override
    public Timestamp getTimestamp(String arg0) throws SQLException {
        return this.current.getTimestamp(arg0);
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        return this.current.getTimestamp(arg0, arg1);
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        return this.current.getTimestamp(arg0, arg1);
    }

    @Override
    public int getType() throws SQLException {
        return this.current.getType();
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        return this.current.getURL(arg0);
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        return this.current.getURL(arg0);
    }

    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        return this.current.getUnicodeStream(arg0);
    }

    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        return this.current.getUnicodeStream(arg0);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.current.getWarnings();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.current == null && this.cursor >= this.comps.size();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.current == null && this.cursor < 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.current != null && this.current.isFirst() && this.cursor == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.current != null && this.current.isLast() && this.cursor == this.comps.size() - 1;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.comps.isEmpty()) {
            return false;
        }
        this.cursor = this.comps.size() - 1;
        this.current = this.comps.getLast();
        return this.current.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.comps.isEmpty()) {
            return false;
        }
        if (this.current == null) {
            this.current = this.comps.getFirst();
            this.cursor = 0;
        }
        if (this.current.next()) {
            return true;
        }
        ++this.cursor;
        if (this.cursor < this.comps.size()) {
            this.current = this.comps.get(this.cursor);
            return this.current.first();
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.comps.isEmpty()) {
            return false;
        }
        if (this.current.previous()) {
            return true;
        }
        --this.cursor;
        if (this.cursor >= 0) {
            this.current = this.comps.get(this.cursor);
            return this.current.last();
        }
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        if (arg0 == 0) {
            return this.current != null;
        }
        boolean forward = arg0 > 0;
        for (int i = 0; i < arg0; ++i) {
            if (!(forward ? !this.next() : !this.previous())) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        for (ResultSet rs : this.comps) {
            rs.setFetchSize(arg0);
        }
    }

    @Override
    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.current.wasNull();
    }

    static {
        try {
            concreteImpl = ConcreteClassGenerator.getConcreteConstructor(DistributedResultSet.class, new Class[0]);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

