/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.validation.ConstraintValidator;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDefaults {
    private static final Log log = LogFactory.getLog(ConstraintDefaults.class);
    private static final String DEFAULT_CONSTRAINTS = "org/apache/bval/jsr303/DefaultConstraints.properties";
    protected Map<String, Class<? extends ConstraintValidator<?, ?>>[]> defaultConstraints = this.loadDefaultConstraints("org/apache/bval/jsr303/DefaultConstraints.properties");

    public Map<String, Class<? extends ConstraintValidator<?, ?>>[]> getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public <A extends Annotation> Class<? extends ConstraintValidator<A, ?>>[] getValidatorClasses(Class<A> annotationType) {
        return this.getDefaultConstraints().get(annotationType.getName());
    }

    private Map<String, Class<? extends ConstraintValidator<?, ?>>[]> loadDefaultConstraints(String resource) {
        Properties constraintProperties = new Properties();
        final ClassLoader classloader = this.getClassLoader();
        InputStream stream = classloader.getResourceAsStream(resource);
        if (stream != null) {
            try {
                constraintProperties.load(stream);
            }
            catch (IOException e) {
                log.error("cannot load " + resource, e);
            }
        } else {
            log.warn("cannot find " + resource);
        }
        HashMap<String, Class<? extends ConstraintValidator<?, ?>>[]> loadedConstraints = new HashMap<String, Class<? extends ConstraintValidator<?, ?>>[]>();
        for (Map.Entry<Object, Object> entry : constraintProperties.entrySet()) {
            StringTokenizer tokens = new StringTokenizer((String)entry.getValue(), ", ");
            LinkedList<Class> classes = new LinkedList<Class>();
            while (tokens.hasMoreTokens()) {
                final String eachClassName = tokens.nextToken();
                Class constraintValidatorClass = SecureActions.run(new PrivilegedAction<Class>(){

                    @Override
                    public Class run() {
                        try {
                            return Class.forName(eachClassName, true, classloader);
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Cannot find class " + eachClassName, e);
                            return null;
                        }
                    }
                });
                if (constraintValidatorClass == null) continue;
                classes.add(constraintValidatorClass);
            }
            loadedConstraints.put((String)entry.getKey(), classes.toArray(new Class[classes.size()]));
        }
        return loadedConstraints;
    }

    private ClassLoader getClassLoader() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = this.getClass().getClassLoader();
        }
        return classloader;
    }
}

