/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.resolver;

import java.lang.annotation.ElementType;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.apache.bval.jsr303.resolver.CachingRelevant;
import org.apache.bval.jsr303.resolver.CachingTraversableResolver;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTraversableResolver
implements TraversableResolver,
CachingRelevant {
    private static final Log log = LogFactory.getLog(DefaultTraversableResolver.class);
    private static final String PERSISTENCE_UTIL_CLASSNAME = "javax.persistence.PersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME = "org.apache.bval.jsr303.resolver.JPATraversableResolver";
    private TraversableResolver jpaTR;

    public DefaultTraversableResolver() {
        this.initJpa();
    }

    @Override
    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    @Override
    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private void initJpa() {
        try {
            ClassUtils.getClass(PERSISTENCE_UTIL_CLASSNAME);
            if (log.isDebugEnabled()) {
                log.debug("Found javax.persistence.PersistenceUtil on classpath.");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot find javax.persistence.PersistenceUtil on classpath. All properties will per default be traversable.");
            }
            return;
        }
        try {
            Class jpaAwareResolverClass = ClassUtils.getClass(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME);
            this.jpaTR = (TraversableResolver)SecureActions.newInstance(jpaAwareResolverClass);
            if (log.isDebugEnabled()) {
                log.debug("Instantiated an instance of org.apache.bval.jsr303.resolver.JPATraversableResolver.");
            }
        }
        catch (Exception e) {
            log.warn("Unable to load or instanciate JPA aware resolver org.apache.bval.jsr303.resolver.JPATraversableResolver. All properties will per default be traversable.", e);
        }
    }

    @Override
    public boolean needsCaching() {
        return this.jpaTR != null && CachingTraversableResolver.needsCaching(this.jpaTR);
    }
}

