/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.PrivilegedActions;

public class FieldAccess
extends AccessStrategy {
    private final Field field;

    public FieldAccess(Field field) {
        this.field = field;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public Object get(final Object instance) {
        return PrivilegedActions.run(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return FieldAccess.this.field.get(instance);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    public Type getJavaType() {
        return this.field.getGenericType();
    }

    public String getPropertyName() {
        return this.field.getName();
    }

    public String toString() {
        return this.field.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldAccess that = (FieldAccess)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

