/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import org.apache.openjpa.kernel.FinalizingBrokerImpl;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.DistributedBroker;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.DistributedQueryImpl;
import org.apache.openjpa.slice.DistributedStoreManager;
import org.apache.openjpa.slice.FinderTargetPolicy;
import org.apache.openjpa.slice.ReentrantSliceLock;
import org.apache.openjpa.slice.SliceImplHelper;
import org.apache.openjpa.slice.SliceInfo;
import org.apache.openjpa.slice.jdbc.TargetFetchConfiguration;
import org.apache.openjpa.util.OpenJPAId;

public class DistributedBrokerImpl
extends FinalizingBrokerImpl
implements DistributedBroker {
    private transient String _rootSlice;
    private transient DistributedConfiguration _conf;
    private final ReentrantSliceLock _lock = new ReentrantSliceLock();
    private static final Localizer _loc = Localizer.forPackage(DistributedBrokerImpl.class);

    @Override
    public DistributedConfiguration getConfiguration() {
        if (this._conf == null) {
            this._conf = (DistributedConfiguration)super.getConfiguration();
        }
        return this._conf;
    }

    @Override
    public DistributedStoreManager getDistributedStoreManager() {
        return (DistributedStoreManager)this.getStoreManager().getInnermostDelegate();
    }

    @Override
    public TargetFetchConfiguration getFetchConfiguration() {
        return (TargetFetchConfiguration)super.getFetchConfiguration();
    }

    @Override
    public OpenJPAStateManager persist(Object pc, Object id, boolean explicit, OpCallbacks call) {
        OpenJPAStateManager sm = this.getStateManager(pc);
        SliceInfo info = null;
        boolean replicated = SliceImplHelper.isReplicated(pc, this.getConfiguration());
        if (this.getOperatingSet().isEmpty() && !SliceImplHelper.isSliceAssigned(sm) && (info = SliceImplHelper.getSlicesByPolicy(pc, this.getConfiguration(), (Object)this)) != null) {
            this._rootSlice = info.getSlices()[0];
        }
        if (sm == null) {
            sm = super.persist(pc, id, explicit, call);
        }
        if (!SliceImplHelper.isSliceAssigned(sm)) {
            if (info == null) {
                SliceInfo sliceInfo = replicated ? SliceImplHelper.getSlicesByPolicy(pc, this.getConfiguration(), (Object)this) : (info = this._rootSlice != null ? new SliceInfo(this._rootSlice) : null);
            }
            if (info != null) {
                info.setInto(sm);
            }
        }
        return sm;
    }

    @Override
    protected void setStateManager(Object id, StateManagerImpl sm, int status) {
        try {
            super.setStateManager(id, sm, status);
        }
        catch (Exception e) {
            if (status == 0) {
                // empty if block
            }
        }
    }

    @Override
    public boolean endOperation() {
        try {
            return super.endOperation();
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    protected QueryImpl newQueryImpl(String lang, StoreQuery sq) {
        return new DistributedQueryImpl(this, lang, sq);
    }

    @Override
    public void lock() {
        this._lock.lock();
    }

    @Override
    public void unlock() {
        this._lock.unlock();
    }

    @Override
    public void beginStore() {
    }

    @Override
    public Object processArgument(Object oid) {
        FinderTargetPolicy policy;
        TargetFetchConfiguration fetch = this.getFetchConfiguration();
        if (!fetch.isExplicitTarget() && (policy = this._conf.getFinderTargetPolicyInstance()) != null && oid instanceof OpenJPAId) {
            String[] targets = policy.getTargets(((OpenJPAId)oid).getType(), ((OpenJPAId)oid).getIdObject(), this._conf.getActiveSliceNames(), this);
            fetch.setTargets(targets);
        }
        return super.processArgument(oid);
    }
}

