/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.BinaryConditionalOperator;
import org.apache.openjpa.persistence.query.BinaryExpressionPredicate;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.JPQLHelper;

public class LikeExpression
extends BinaryExpressionPredicate {
    private final Object _echar;
    private final boolean _escaped;

    public LikeExpression(Expression e, Expression pattern, Object echar) {
        super(e, BinaryConditionalOperator.LIKE, BinaryConditionalOperator.LIKE_NOT, pattern);
        this._echar = echar;
        this._escaped = true;
    }

    public LikeExpression(Expression e, Expression pattern) {
        super(e, BinaryConditionalOperator.LIKE, BinaryConditionalOperator.LIKE_NOT, pattern);
        this._echar = null;
        this._escaped = false;
    }

    @Override
    public String asExpression(AliasContext ctx) {
        return super.asExpression(ctx) + (this._escaped ? "ESCAPE " + JPQLHelper.toJPQL(ctx, this._echar) : "");
    }
}

