/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import relations.Deity;

public class Main {
    public static void main(String[] args) {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"relations", (Map)System.getProperties());
        EntityManager em = factory.createEntityManager();
        Main.initFamilyTree(em);
        Main.runQueries(em);
        em.close();
        factory.close();
    }

    public static void initFamilyTree(EntityManager em) {
        em.getTransaction().begin();
        em.createQuery("delete from Deity").executeUpdate();
        em.getTransaction().commit();
        Deity uranus = new Deity("Uranus", Deity.Gender.MALE);
        Deity gaea = new Deity("Gaea", Deity.Gender.FEMALE);
        Deity cronus = gaea.giveBirth("Cronus", uranus, Deity.Gender.MALE);
        Deity rhea = gaea.giveBirth("Rhea", uranus, Deity.Gender.FEMALE);
        Deity coeus = gaea.giveBirth("Coeus", uranus, Deity.Gender.MALE);
        Deity phoebe = gaea.giveBirth("Phoebe", uranus, Deity.Gender.FEMALE);
        Deity oceanus = gaea.giveBirth("Oceanus", uranus, Deity.Gender.MALE);
        Deity tethys = gaea.giveBirth("Tethys", uranus, Deity.Gender.FEMALE);
        Deity leto = phoebe.giveBirth("Leto", coeus, Deity.Gender.FEMALE);
        Deity hestia = rhea.giveBirth("Hestia", cronus, Deity.Gender.FEMALE);
        Deity pluto = rhea.giveBirth("Pluto", cronus, Deity.Gender.MALE);
        Deity poseidon = rhea.giveBirth("Poseidon", cronus, Deity.Gender.MALE);
        Deity zeus = rhea.giveBirth("Zeus", cronus, Deity.Gender.MALE);
        Deity hera = rhea.giveBirth("Hera", cronus, Deity.Gender.FEMALE);
        Deity demeter = rhea.giveBirth("Demeter", cronus, Deity.Gender.FEMALE);
        Deity iapetus = tethys.giveBirth("Iapetus", coeus, Deity.Gender.MALE);
        Deity clymene = new Deity("Clymene", Deity.Gender.FEMALE);
        Deity apollo = leto.giveBirth("Apollo", zeus, Deity.Gender.MALE);
        Deity artemis = leto.giveBirth("Artemis", zeus, Deity.Gender.MALE);
        Deity persephone = demeter.giveBirth("Persephone", zeus, Deity.Gender.MALE);
        Deity ares = hera.giveBirth("Ares", zeus, Deity.Gender.MALE);
        Deity hebe = hera.giveBirth("Hebe", zeus, Deity.Gender.FEMALE);
        Deity hephaestus = hera.giveBirth("Hephaestus", zeus, Deity.Gender.MALE);
        Deity prometheus = clymene.giveBirth("Prometheus", iapetus, Deity.Gender.MALE);
        Deity atlas = clymene.giveBirth("Atlas", iapetus, Deity.Gender.MALE);
        Deity epimetheus = clymene.giveBirth("Epimetheus", iapetus, Deity.Gender.FEMALE);
        Deity dione = new Deity("Dione", Deity.Gender.FEMALE);
        dione.giveBirth("Aphrodite", zeus, Deity.Gender.FEMALE);
        em.getTransaction().begin();
        em.persist((Object)zeus);
        em.getTransaction().commit();
    }

    public static void runQueries(EntityManager em) {
        System.out.println("Running query to find all instances..");
        Query q = em.createQuery("select x from Deity x");
        for (Deity m : q.getResultList()) {
            System.out.println(m.getName());
        }
        q = em.createQuery("select x from Deity x where x.father.name = 'Zeus'");
        for (Deity m : q.getResultList()) {
            System.out.println("Child of Zeus: " + m.getName());
        }
        q = em.createNamedQuery("siblings").setParameter(1, em.getReference(Deity.class, (Object)"Rhea"));
        for (Deity m : em.createNamedQuery("siblings").setParameter(1, em.getReference(Deity.class, (Object)"Rhea")).getResultList()) {
            System.out.println("Siblings of Rhea: " + m.getName());
        }
        for (Deity m : em.createNamedQuery("half-siblings").setParameter(1, em.getReference(Deity.class, (Object)"Apollo")).getResultList()) {
            System.out.println("Half-siblings of Apollo: " + m.getName());
        }
        for (Deity m : em.createNamedQuery("cousins").setParameter(1, em.getReference(Deity.class, (Object)"Leto")).getResultList()) {
            System.out.println("Cousins of Leto: " + m.getName());
        }
    }
}

