/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.DatabasePlatform;

public abstract class PersistenceTestCase
extends TestCase {
    private static FixedMap _emfs = new FixedMap();
    public static final String FRESH_EMF = "Creates new EntityManagerFactory";
    public static final String RETAIN_DATA = "Retain data after test run";
    private boolean retainDataOnTearDown;
    protected boolean _fresh = false;
    public static String ALLOW_FAILURE_LOG = "log";
    public static String ALLOW_FAILURE_IGNORE = "ignore";
    public static String ALLOW_FAILURE_SYS_PROP = "tests.openjpa.allowfailure";
    private static String allowFailureConfig = System.getProperty(ALLOW_FAILURE_SYS_PROP, ALLOW_FAILURE_IGNORE);
    protected static final Object CLEAR_TABLES = new Object();
    protected static final Object DROP_TABLES = new Object();
    protected TestResult testResult;

    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        return this.createNamedEMF(this.getPersistenceUnitName(), props);
    }

    protected String getPersistenceUnitName() {
        return "test";
    }

    protected OpenJPAEntityManagerFactorySPI createNamedEMF(String pu, Object ... props) {
        Map<String, Object> map = this.getPropertiesMap(props);
        EMFKey key = new EMFKey(pu, map);
        OpenJPAEntityManagerFactorySPI oemf = (OpenJPAEntityManagerFactorySPI)_emfs.get(key);
        if (this._fresh || oemf == null || !oemf.isOpen()) {
            HashMap<Object, Object> config = new HashMap<Object, Object>(System.getProperties());
            config.putAll(map);
            oemf = (OpenJPAEntityManagerFactorySPI)Persistence.createEntityManagerFactory((String)pu, config);
            if (oemf == null) {
                throw new NullPointerException("Expected an entity manager factory for the persistence unit named: \"" + pu + "\"");
            }
            if (!this._fresh) {
                _emfs.put(key, oemf);
            }
        }
        this._fresh = false;
        return oemf;
    }

    protected Map<String, Object> getPropertiesMap(Object ... props) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Class> types = new ArrayList<Class>();
        boolean prop = false;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (props[i] == FRESH_EMF) {
                this._fresh = true;
                continue;
            }
            if (props[i] == RETAIN_DATA) {
                this.retainDataOnTearDown = true;
                continue;
            }
            if (prop) {
                map.put((String)props[i - 1], props[i]);
                prop = false;
                continue;
            }
            if (props[i] == CLEAR_TABLES) {
                map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='add,deleteTableContents')");
                continue;
            }
            if (props[i] == DROP_TABLES) {
                map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='drop,add')");
                continue;
            }
            if (props[i] instanceof Class) {
                types.add((Class)props[i]);
                continue;
            }
            if (props[i] == null) continue;
            prop = true;
        }
        if (!types.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            for (Class c : types) {
                if (buf.length() > 0) {
                    buf.append(";");
                }
                buf.append(c.getName());
            }
            String oldValue = map.containsKey("openjpa.MetaDataFactory") ? "," + map.get("openjpa.MetaDataFactory").toString() : "";
            map.put("openjpa.MetaDataFactory", "jpa(Types=" + buf.toString() + oldValue + ")");
        } else {
            map.put("openjpa.MetaDataFactory", "jpa");
        }
        return map;
    }

    public void run(TestResult testResult) {
        this.testResult = testResult;
        super.run(testResult);
    }

    public void tearDown() throws Exception {
        block2: {
            try {
                super.tearDown();
            }
            catch (Exception e) {
                if (!this.testResult.wasSuccessful()) break block2;
                throw e;
            }
        }
    }

    protected boolean closeEMF(EntityManagerFactory emf) {
        if (emf == null || !emf.isOpen()) {
            return false;
        }
        this.closeAllOpenEMs(emf);
        emf.close();
        return !emf.isOpen();
    }

    protected void closeAllOpenEMs(EntityManagerFactory emf) {
        if (emf == null || !emf.isOpen()) {
            return;
        }
        for (Broker b : ((AbstractBrokerFactory)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf)).getOpenBrokers()) {
            if (b == null || b.isClosed()) continue;
            OpenJPAEntityManager em = JPAFacadeHelper.toEntityManager((Broker)b);
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    protected void clear(EntityManagerFactory emf, Class ... types) {
        if (emf == null || types.length == 0) {
            return;
        }
        ArrayList<ClassMetaData> metas = new ArrayList<ClassMetaData>(types.length);
        for (Class c : types) {
            ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)emf, (Class)c);
            if (meta == null) continue;
            metas.add(meta);
        }
        this.clear(emf, false, metas.toArray(new ClassMetaData[metas.size()]));
    }

    protected void clear(EntityManagerFactory emf) {
        if (emf == null) {
            return;
        }
        this.clear(emf, true, ((OpenJPAEntityManagerFactorySPI)emf).getConfiguration().getMetaDataRepositoryInstance().getMetaDatas());
    }

    private void clear(EntityManagerFactory emf, boolean closeEMs, ClassMetaData ... types) {
        if (emf == null || types.length == 0) {
            return;
        }
        if (closeEMs) {
            this.closeAllOpenEMs(emf);
        }
        if (this.retainDataOnTearDown) {
            return;
        }
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        for (ClassMetaData meta : types) {
            if (!meta.isMapped() || meta.isEmbeddedOnly() || Modifier.isAbstract(meta.getDescribedType().getModifiers()) && !this.isBaseManagedInterface(meta, types)) continue;
            em.createQuery("DELETE FROM " + meta.getTypeAlias() + " o").executeUpdate();
        }
        em.getTransaction().commit();
        em.close();
    }

    protected String entityName(EntityManagerFactory emf, Class c) {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)emf, (Class)c);
        return meta == null ? null : meta.getTypeAlias();
    }

    private boolean isBaseManagedInterface(ClassMetaData meta, ClassMetaData ... types) {
        return Modifier.isInterface(meta.getDescribedType().getModifiers()) && !this.isExtendedManagedInterface(meta, types);
    }

    private boolean isExtendedManagedInterface(ClassMetaData meta, ClassMetaData ... types) {
        if (!Modifier.isInterface(meta.getDescribedType().getModifiers())) {
            return false;
        }
        Class<?>[] ifaces = meta.getDescribedType().getInterfaces();
        for (int i = 0; ifaces != null && i < ifaces.length; ++i) {
            for (ClassMetaData meta2 : types) {
                if (!ifaces[i].equals(meta2.getDescribedType())) continue;
                return true;
            }
        }
        return false;
    }

    public static void assertNotEquals(Object o1, Object o2) {
        if (o1 == o2) {
            PersistenceTestCase.fail((String)"expected args to be different; were the same instance.");
        } else {
            if (o1 == null || o2 == null) {
                return;
            }
            if (o1.equals(o2)) {
                PersistenceTestCase.fail((String)"expected args to be different; compared equal.");
            }
        }
    }

    public static <T> T roundtrip(T o) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(o);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
        return (T)in.readObject();
    }

    protected void assertException(Throwable actual, Class targetType) {
        this.assertException(actual, targetType, null);
    }

    protected void assertException(Throwable actual, Class targetType, Class nestedTargetType) {
        PersistenceTestCase.assertNotNull((Object)actual);
        Class<?> actualType = actual.getClass();
        if (targetType != null && !targetType.isAssignableFrom(actualType)) {
            actual.printStackTrace();
            PersistenceTestCase.fail((String)(targetType.getName() + " is not assignable from " + actualType.getName()));
        }
        if (nestedTargetType != null) {
            Class<?> nestedActualType;
            Throwable nested = actual.getCause();
            Class<?> clazz = nestedActualType = nested == null ? null : nested.getClass();
            while (nestedActualType != null) {
                if (nestedTargetType.isAssignableFrom(nestedActualType)) {
                    return;
                }
                Throwable next = nested.getCause();
                if (next == null || next == nested) break;
                nestedActualType = next.getClass();
                nested = next;
            }
            actual.printStackTrace();
            PersistenceTestCase.fail((String)("No nested type " + nestedTargetType + " in " + actual));
        }
    }

    protected void assertExceptionMessage(Throwable actual, Class targetType, String ... messages) {
        this.assertException(actual, targetType, null);
        this.assertMessage(actual, messages);
    }

    protected void assertMessage(Throwable actual, String ... keys) {
        if (actual == null || keys == null) {
            return;
        }
        String message = actual.getMessage();
        for (String key : keys) {
            PersistenceTestCase.assertTrue((String)(key + " is not in " + message), (boolean)message.contains(key));
        }
    }

    public void printException(Throwable t) {
        this.printException(t, 2);
    }

    public void printException(Throwable t, int tab) {
        if (t == null) {
            return;
        }
        for (int i = 0; i < tab * 4; ++i) {
            System.out.print(" ");
        }
        String sqlState = t instanceof SQLException ? "(SQLState=" + ((SQLException)t).getSQLState() + ":" + t.getMessage() + ")" : "";
        System.out.println(t.getClass().getName() + sqlState);
        if (t.getCause() == t) {
            return;
        }
        this.printException(t.getCause(), tab + 2);
    }

    public void runBare() throws Throwable {
        if (!this.isRunsOnCurrentPlatform()) {
            return;
        }
        this.runBare(this.getAllowFailure());
    }

    protected void runBare(AllowFailure allowFailureAnnotation) throws Throwable {
        boolean allowFailureValue;
        boolean bl = allowFailureValue = allowFailureAnnotation == null ? false : allowFailureAnnotation.value();
        if (allowFailureValue) {
            if (ALLOW_FAILURE_IGNORE.equalsIgnoreCase(allowFailureConfig)) {
                return;
            }
            try {
                super.runBare();
            }
            catch (Throwable t) {
                if (ALLOW_FAILURE_LOG.equalsIgnoreCase(allowFailureConfig)) {
                    System.err.println("*** FAILED (but ignored): " + (Object)((Object)this));
                    System.err.println("***              Reason : " + allowFailureAnnotation.message());
                    System.err.println("Stacktrace of failure");
                    t.printStackTrace();
                }
                throw t;
            }
        } else {
            super.runBare();
        }
    }

    protected AllowFailure getAllowFailure() {
        try {
            Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), null);
            AllowFailure anno = runMethod.getAnnotation(AllowFailure.class);
            if (anno != null) {
                return anno;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return ((Object)((Object)this)).getClass().getAnnotation(AllowFailure.class);
    }

    protected boolean isRunsOnCurrentPlatform() {
        DatabasePlatform anno = ((Object)((Object)this)).getClass().getAnnotation(DatabasePlatform.class);
        if (anno == null) {
            return true;
        }
        if (anno != null) {
            String[] drivers;
            String value = anno.value();
            if (value == null || value.trim().length() == 0) {
                return true;
            }
            for (String driver : drivers = value.split("\\,")) {
                try {
                    Class.forName(driver.trim(), false, Thread.currentThread().getContextClassLoader());
                    return true;
                }
                catch (Throwable t) {
                }
            }
        }
        return false;
    }

    public boolean isTargetPlatform(String target) {
        String url = this.getPlatform();
        return url != null && url.indexOf(target) != -1;
    }

    public String getPlatform() {
        return System.getProperty("platform", "derby");
    }

    private static class EMFKey {
        final String unit;
        final Map config;

        EMFKey(String unit, Map config) {
            this.unit = unit;
            this.config = config;
        }

        public int hashCode() {
            return (this.unit != null ? this.unit.hashCode() : 0) + this.config.hashCode();
        }

        public boolean equals(Object other) {
            EMFKey that = (EMFKey)other;
            return (this.unit != null ? this.unit.equals(that.unit) : that.unit == null) && this.config.equals(that.config);
        }
    }

    private static class FixedMap
    extends LinkedHashMap<EMFKey, OpenJPAEntityManagerFactorySPI> {
        private FixedMap() {
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<EMFKey, OpenJPAEntityManagerFactorySPI> entry) {
            return this.size() > 2;
        }
    }
}

