/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.DataCacheRetrieveMode;
import org.apache.openjpa.kernel.DataCacheStoreMode;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.rop.EagerResultList;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.rop.SimpleResultList;
import org.apache.openjpa.lib.rop.WindowResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.NoTransactionException;
import org.apache.openjpa.util.UserException;

public class FetchConfigurationImpl
implements FetchConfiguration,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(FetchConfigurationImpl.class);
    private static Map<String, Method> _hintSetters = new HashMap<String, Method>();
    private final ConfigurationState _state;
    private FetchConfigurationImpl _parent;
    private String _fromField;
    private Class<?> _fromType;
    private String _directRelationOwner;
    private boolean _load = true;
    private int _availableRecursion;
    private int _availableDepth;

    protected static void populateHintSetter(Class<?> target, String hint, Class<?> type, String ... prefixes) {
        FetchConfigurationImpl.populateHintSetter(target, "set" + hint, hint, type, prefixes);
    }

    protected static void populateHintSetter(Class<?> target, String method, String hint, Class<?> type, String ... prefixes) {
        try {
            Method setter = target.getMethod(method, type);
            for (String prefix : prefixes) {
                _hintSetters.put(prefix + "." + hint, setter);
            }
        }
        catch (Exception e) {
            throw new InternalException("setter for " + hint + " with argument " + String.valueOf(type) + " does not exist");
        }
    }

    public FetchConfigurationImpl() {
        this(null);
    }

    protected FetchConfigurationImpl(ConfigurationState state) {
        this._state = state == null ? new ConfigurationState() : state;
        this._availableDepth = this._state.maxFetchDepth;
    }

    @Override
    public StoreContext getContext() {
        return this._state.ctx;
    }

    @Override
    public void setContext(StoreContext ctx) {
        if (ctx != null && this._state.ctx != null && ctx != this._state.ctx) {
            throw new InternalException();
        }
        this._state.ctx = ctx;
        if (ctx == null) {
            return;
        }
        OpenJPAConfiguration conf = ctx.getConfiguration();
        this.setFetchBatchSize(conf.getFetchBatchSize());
        this.setFlushBeforeQueries(conf.getFlushBeforeQueriesConstant());
        this.setLockTimeout(conf.getLockTimeout());
        this.setQueryTimeout(conf.getQueryTimeout());
        String[] fetchGroupList = conf.getFetchGroupsList();
        this.clearFetchGroups(fetchGroupList == null || fetchGroupList.length == 0);
        this.addFetchGroups(Arrays.asList(fetchGroupList));
        this.setMaxFetchDepth(conf.getMaxFetchDepth());
        this._state.cacheNonDefaultFetchPlanQueries = conf.getCompatibilityInstance().getCacheNonDefaultFetchPlanQueries();
    }

    @Override
    public Object clone() {
        FetchConfigurationImpl clone = this.newInstance(null);
        clone._state.ctx = this._state.ctx;
        clone._state.cacheNonDefaultFetchPlanQueries = this._state.cacheNonDefaultFetchPlanQueries;
        clone._parent = this._parent;
        clone._fromField = this._fromField;
        clone._fromType = this._fromType;
        clone._directRelationOwner = this._directRelationOwner;
        clone._load = this._load;
        clone._availableRecursion = this._availableRecursion;
        clone._availableDepth = this._availableDepth;
        clone.copy(this);
        return clone;
    }

    protected FetchConfigurationImpl newInstance(ConfigurationState state) {
        return new FetchConfigurationImpl(state);
    }

    @Override
    public void copy(FetchConfiguration fetch) {
        this.setFetchBatchSize(fetch.getFetchBatchSize());
        this.setMaxFetchDepth(fetch.getMaxFetchDepth());
        this.setQueryCacheEnabled(fetch.getQueryCacheEnabled());
        this.setFlushBeforeQueries(fetch.getFlushBeforeQueries());
        this.setExtendedPathLookup(fetch.getExtendedPathLookup());
        this.setLockTimeout(fetch.getLockTimeout());
        this.setQueryTimeout(fetch.getQueryTimeout());
        this.setLockScope(fetch.getLockScope());
        this.clearFetchGroups(false);
        this.addFetchGroups(fetch.getFetchGroups());
        this.clearFields();
        this.copyHints(fetch);
        this.setCacheRetrieveMode(fetch.getCacheRetrieveMode());
        this.setCacheStoreMode(fetch.getCacheStoreMode());
        this.addFields(fetch.getFields());
        this._state.readLockLevel = fetch.getReadLockLevel();
        this._state.writeLockLevel = fetch.getWriteLockLevel();
    }

    void copyHints(FetchConfiguration fetch) {
        if (!(fetch instanceof FetchConfigurationImpl)) {
            return;
        }
        FetchConfigurationImpl from = (FetchConfigurationImpl)fetch;
        if (from._state == null || from._state.hints == null) {
            return;
        }
        if (this._state == null) {
            return;
        }
        if (this._state.hints == null) {
            this._state.hints = new HashMap<String, Object>();
        }
        this._state.hints.putAll(from._state.hints);
    }

    @Override
    public int getFetchBatchSize() {
        return this._state.fetchBatchSize;
    }

    @Override
    public FetchConfiguration setFetchBatchSize(int fetchBatchSize) {
        if (fetchBatchSize == -99 && this._state.ctx != null) {
            fetchBatchSize = this._state.ctx.getConfiguration().getFetchBatchSize();
        }
        if (fetchBatchSize != -99) {
            this._state.fetchBatchSize = fetchBatchSize;
        }
        return this;
    }

    @Override
    public int getMaxFetchDepth() {
        return this._state.maxFetchDepth;
    }

    @Override
    public FetchConfiguration setMaxFetchDepth(int depth) {
        if (depth == -99 && this._state.ctx != null) {
            depth = this._state.ctx.getConfiguration().getMaxFetchDepth();
        }
        if (depth != -99) {
            this._state.maxFetchDepth = depth;
            if (this._parent == null) {
                this._availableDepth = depth;
            }
        }
        return this;
    }

    @Override
    public boolean getQueryCacheEnabled() {
        return this._state.queryCache;
    }

    @Override
    public FetchConfiguration setQueryCacheEnabled(boolean cache) {
        this._state.queryCache = cache;
        return this;
    }

    @Override
    public int getFlushBeforeQueries() {
        return this._state.flushQuery;
    }

    @Override
    public boolean getExtendedPathLookup() {
        return this._state.extendedPathLookup;
    }

    @Override
    public FetchConfiguration setExtendedPathLookup(boolean flag) {
        this._state.extendedPathLookup = flag;
        return this;
    }

    @Override
    public FetchConfiguration setFlushBeforeQueries(int flush) {
        if (flush != -99 && flush != 0 && flush != 1 && flush != 2) {
            throw new IllegalArgumentException(_loc.get("bad-flush-before-queries", (Object)flush).getMessage());
        }
        if (flush == -99 && this._state.ctx != null) {
            this._state.flushQuery = this._state.ctx.getConfiguration().getFlushBeforeQueriesConstant();
        } else if (flush != -99) {
            this._state.flushQuery = flush;
        }
        return this;
    }

    @Override
    public Set<String> getFetchGroups() {
        if (this._state.fetchGroups == null) {
            return Collections.emptySet();
        }
        return this._state.fetchGroups;
    }

    @Override
    public boolean hasFetchGroup(String group) {
        return this._state.fetchGroups != null && (this._state.fetchGroups.contains(group) || this._state.fetchGroups.contains("all"));
    }

    public boolean hasFetchGroupDefault() {
        return this._state.fetchGroupContainsDefault || this._state.fetchGroupContainsAll;
    }

    public boolean hasFetchGroupAll() {
        return this._state.fetchGroupContainsAll;
    }

    @Override
    public FetchConfiguration addFetchGroup(String name) {
        return this.addFetchGroup(name, true);
    }

    private FetchConfiguration addFetchGroup(String name, boolean recomputeIsDefault) {
        if (StringUtil.isEmpty((String)name)) {
            throw new UserException(_loc.get("null-fg"));
        }
        this.lock();
        try {
            if (this._state.fetchGroups == null) {
                this._state.fetchGroups = new HashSet<String>();
            }
            this._state.fetchGroups.add(name);
            if ("all".equals(name)) {
                this._state.fetchGroupContainsAll = true;
            } else if ("default".equals(name)) {
                this._state.fetchGroupContainsDefault = true;
            }
        }
        finally {
            if (recomputeIsDefault) {
                this.verifyDefaultPUFetchGroups();
            }
            this.unlock();
        }
        return this;
    }

    @Override
    public FetchConfiguration addFetchGroups(Collection<String> groups) {
        if (groups == null || groups.isEmpty()) {
            return this;
        }
        for (String group : groups) {
            this.addFetchGroup(group, false);
        }
        this.verifyDefaultPUFetchGroups();
        return this;
    }

    @Override
    public FetchConfiguration removeFetchGroup(String group) {
        return this.removeFetchGroup(group, true);
    }

    private FetchConfiguration removeFetchGroup(String group, boolean recomputeIsDefault) {
        this.lock();
        try {
            if (this._state.fetchGroups != null) {
                this._state.fetchGroups.remove(group);
                if ("all".equals(group)) {
                    this._state.fetchGroupContainsAll = false;
                } else if ("default".equals(group)) {
                    this._state.fetchGroupContainsDefault = false;
                }
            }
        }
        finally {
            if (recomputeIsDefault) {
                this.verifyDefaultPUFetchGroups();
            }
            this.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration removeFetchGroups(Collection<String> groups) {
        this.lock();
        try {
            if (this._state.fetchGroups != null && groups != null) {
                for (String group : groups) {
                    this.removeFetchGroup(group, false);
                }
            }
        }
        finally {
            this.verifyDefaultPUFetchGroups();
            this.unlock();
        }
        return this;
    }

    @Override
    public FetchConfiguration clearFetchGroups() {
        return this.clearFetchGroups(true);
    }

    private FetchConfiguration clearFetchGroups(boolean restoresDefault) {
        this.lock();
        try {
            if (this._state.fetchGroups != null) {
                this._state.fetchGroups.clear();
            } else {
                this._state.fetchGroups = new HashSet<String>();
            }
            this._state.fetchGroupContainsAll = false;
            if (restoresDefault) {
                this._state.fetchGroupContainsDefault = true;
                this._state.fetchGroups.add("default");
            }
        }
        finally {
            this.verifyDefaultPUFetchGroups();
            this.unlock();
        }
        return this;
    }

    @Override
    public FetchConfiguration resetFetchGroups() {
        String[] fetchGroupList = this._state.ctx.getConfiguration().getFetchGroupsList();
        this.clearFetchGroups(fetchGroupList == null || fetchGroupList.length == 0);
        if (this._state.ctx != null) {
            this.addFetchGroups(Arrays.asList(fetchGroupList));
        }
        this.verifyDefaultPUFetchGroups();
        return this;
    }

    private void verifyDefaultPUFetchGroups() {
        this._state.fetchGroupIsPUDefault = false;
        if (this._state.fields != null && !this._state.fields.isEmpty()) {
            return;
        }
        if (this._state.fetchGroups != null && this._state.ctx != null) {
            List<String> defaultPUFetchGroups = Arrays.asList(this._state.ctx.getConfiguration().getFetchGroupsList());
            if (this._state.fetchGroups.size() != defaultPUFetchGroups.size()) {
                return;
            }
            for (String fetchGroupName : defaultPUFetchGroups) {
                if (this._state.fetchGroups.contains(fetchGroupName)) continue;
                return;
            }
            this._state.fetchGroupIsPUDefault = true;
        }
    }

    @Override
    public boolean isDefaultPUFetchGroupConfigurationOnly() {
        return this._state.fetchGroupIsPUDefault;
    }

    @Override
    public boolean isFetchConfigurationSQLCacheAdmissible() {
        if (this._state == null || this._state.cacheNonDefaultFetchPlanQueries) {
            return false;
        }
        return this._state.fetchGroupIsPUDefault;
    }

    @Override
    public Set<String> getFields() {
        if (this._state.fields == null) {
            return Collections.emptySet();
        }
        return this._state.fields;
    }

    @Override
    public boolean hasField(String field) {
        return this._state.fields != null && this._state.fields.contains(field);
    }

    @Override
    public FetchConfiguration addField(String field) {
        if (StringUtil.isEmpty((String)field)) {
            throw new UserException(_loc.get("null-field"));
        }
        this.lock();
        try {
            if (this._state.fields == null) {
                this._state.fields = new HashSet<String>();
            }
            this._state.fields.add(field);
            this._state.fetchGroupIsPUDefault = false;
        }
        finally {
            this.unlock();
        }
        return this;
    }

    @Override
    public FetchConfiguration addFields(Collection<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        this.lock();
        try {
            if (this._state.fields == null) {
                this._state.fields = new HashSet<String>();
            }
            this._state.fields.addAll(fields);
        }
        finally {
            this.verifyDefaultPUFetchGroups();
            this.unlock();
        }
        return this;
    }

    @Override
    public FetchConfiguration removeField(String field) {
        this.lock();
        try {
            if (this._state.fields != null) {
                this._state.fields.remove(field);
                if (this._state.fields.size() == 0) {
                    this.verifyDefaultPUFetchGroups();
                }
            }
        }
        finally {
            this.unlock();
        }
        return this;
    }

    @Override
    public FetchConfiguration removeFields(Collection<String> fields) {
        this.lock();
        try {
            if (this._state.fields != null) {
                this._state.fields.removeAll(fields);
            }
        }
        finally {
            this.unlock();
        }
        return this;
    }

    @Override
    public FetchConfiguration clearFields() {
        this.lock();
        try {
            if (this._state.fields != null) {
                this._state.fields.clear();
            }
        }
        finally {
            this.verifyDefaultPUFetchGroups();
            this.unlock();
        }
        return this;
    }

    @Override
    public DataCacheRetrieveMode getCacheRetrieveMode() {
        return this._state.cacheRetrieveMode;
    }

    @Override
    public DataCacheStoreMode getCacheStoreMode() {
        return this._state.cacheStoreMode;
    }

    @Override
    public void setCacheRetrieveMode(DataCacheRetrieveMode mode) {
        this._state.cacheRetrieveMode = mode;
    }

    @Override
    public void setCacheStoreMode(DataCacheStoreMode mode) {
        this._state.cacheStoreMode = mode;
    }

    @Override
    public int getLockTimeout() {
        return this._state.lockTimeout;
    }

    @Override
    public FetchConfiguration setLockTimeout(int timeout) {
        if (timeout == -99 && this._state.ctx != null) {
            this._state.lockTimeout = this._state.ctx.getConfiguration().getLockTimeout();
        } else if (timeout != -99) {
            if (timeout < -1) {
                throw new IllegalArgumentException(_loc.get("invalid-timeout", (Object)timeout).getMessage());
            }
            this._state.lockTimeout = timeout;
        }
        return this;
    }

    @Override
    public int getQueryTimeout() {
        return this._state.queryTimeout;
    }

    @Override
    public FetchConfiguration setQueryTimeout(int timeout) {
        if (timeout == -99 && this._state.ctx != null) {
            this._state.queryTimeout = this._state.ctx.getConfiguration().getQueryTimeout();
        } else if (timeout != -99) {
            if (timeout < -1) {
                throw new IllegalArgumentException(_loc.get("invalid-timeout", (Object)timeout).getMessage());
            }
            this._state.queryTimeout = timeout;
        }
        return this;
    }

    @Override
    public int getLockScope() {
        return this._state.lockScope;
    }

    @Override
    public FetchConfiguration setLockScope(int scope) {
        if (scope != -99 && scope != 0 && scope != 10) {
            throw new IllegalArgumentException(_loc.get("bad-lock-scope", (Object)scope).getMessage());
        }
        this._state.lockScope = scope == -99 ? 0 : scope;
        return this;
    }

    @Override
    public int getReadLockLevel() {
        return this._state.readLockLevel;
    }

    @Override
    public FetchConfiguration setReadLockLevel(int level) {
        if (this._state.ctx == null) {
            return this;
        }
        if (level != -99 && level != 0 && level != 10 && level != 15 && level != 20 && level != 25 && level != 30 && level != 40 && level != 50) {
            throw new IllegalArgumentException(_loc.get("bad-lock-level", (Object)level).getMessage());
        }
        this.lock();
        try {
            if (level != 0) {
                this.assertActiveTransaction();
            }
            this._state.readLockLevel = level == -99 ? this._state.ctx.getConfiguration().getReadLockLevelConstant() : level;
        }
        finally {
            this.unlock();
        }
        return this;
    }

    @Override
    public int getWriteLockLevel() {
        return this._state.writeLockLevel;
    }

    @Override
    public FetchConfiguration setWriteLockLevel(int level) {
        if (this._state.ctx == null) {
            return this;
        }
        if (level != -99 && level != 0 && level != 10 && level != 15 && level != 20 && level != 25 && level != 30 && level != 40 && level != 50) {
            throw new IllegalArgumentException(_loc.get("bad-lock-level", (Object)level).getMessage());
        }
        this.lock();
        try {
            this.assertActiveTransaction();
            this._state.writeLockLevel = level == -99 ? this._state.ctx.getConfiguration().getWriteLockLevelConstant() : level;
        }
        finally {
            this.unlock();
        }
        return this;
    }

    @Override
    public ResultList<?> newResultList(ResultObjectProvider rop) {
        if (rop instanceof ListResultObjectProvider) {
            return new SimpleResultList(rop);
        }
        if (this._state.fetchBatchSize < 0) {
            return new EagerResultList(rop);
        }
        if (rop.supportsRandomAccess()) {
            return new SimpleResultList(rop);
        }
        return new WindowResultList(rop);
    }

    private void assertActiveTransaction() {
        if (!this.isActiveTransaction()) {
            throw new NoTransactionException(_loc.get("not-active"));
        }
    }

    private boolean isActiveTransaction() {
        return this._state.ctx != null && this._state.ctx.isActive();
    }

    @Override
    public Map<String, Object> getHints() {
        if (this._state.hints == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._state.hints);
    }

    @Override
    public boolean isHintSet(String key) {
        return this._state.hints != null && this._state.hints.containsKey(key);
    }

    public void removeHint(String ... keys) {
        if (keys == null || this._state.hints == null) {
            return;
        }
        for (String key : keys) {
            this._state.hints.remove(key);
        }
    }

    public Collection<String> getSupportedHints() {
        return _hintSetters.keySet();
    }

    @Override
    public void setHint(String key, Object value) {
        this.setHint(key, value, value);
    }

    @Override
    public void setHint(String key, Object value, Object original) {
        if (key == null) {
            return;
        }
        if (_hintSetters.containsKey(key)) {
            Method setter = _hintSetters.get(key);
            String methodName = setter.getName();
            try {
                if ("setReadLockLevel".equals(methodName) && !this.isActiveTransaction()) {
                    this._state.readLockLevel = (Integer)value;
                } else if ("setWriteLockLevel".equals(methodName) && !this.isActiveTransaction()) {
                    this._state.writeLockLevel = (Integer)value;
                } else {
                    setter.invoke((Object)this, Filters.convertToMatchMethodArgument(value, setter));
                }
            }
            catch (Exception e) {
                String message = _loc.get("bad-hint-value", (Object)key, (Object)this.toString(value), (Object)this.toString(original)).getMessage();
                if (e instanceof IllegalArgumentException) {
                    throw new IllegalArgumentException(message);
                }
                throw new IllegalArgumentException(message, e);
            }
        }
        this.addHint(key, original);
    }

    private void addHint(String name, Object value) {
        this.lock();
        try {
            if (this._state.hints == null) {
                this._state.hints = new HashMap<String, Object>();
            }
            this._state.hints.put(name, value);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Object getHint(String name) {
        return this._state.hints == null ? null : this._state.hints.get(name);
    }

    public Object removeHint(String name) {
        return this._state.hints == null ? null : this._state.hints.remove(name);
    }

    @Override
    public Set<Class<?>> getRootClasses() {
        if (this._state.rootClasses == null) {
            return Collections.emptySet();
        }
        return this._state.rootClasses;
    }

    @Override
    public FetchConfiguration setRootClasses(Collection<Class<?>> classes) {
        this.lock();
        try {
            if (this._state.rootClasses != null) {
                this._state.rootClasses.clear();
            }
            if (classes != null && !classes.isEmpty()) {
                if (this._state.rootClasses == null) {
                    this._state.rootClasses = new HashSet(classes);
                } else {
                    this._state.rootClasses.addAll(classes);
                }
            }
        }
        finally {
            this.unlock();
        }
        return this;
    }

    @Override
    public Set<Object> getRootInstances() {
        if (this._state.rootInstances == null) {
            return Collections.emptySet();
        }
        return this._state.rootInstances;
    }

    @Override
    public FetchConfiguration setRootInstances(Collection<?> instances) {
        this.lock();
        try {
            if (this._state.rootInstances != null) {
                this._state.rootInstances.clear();
            }
            if (instances != null && !instances.isEmpty()) {
                if (this._state.rootInstances == null) {
                    this._state.rootInstances = new HashSet(instances);
                } else {
                    this._state.rootInstances.addAll(instances);
                }
            }
        }
        finally {
            this.unlock();
        }
        return this;
    }

    @Override
    public void lock() {
        if (this._state.ctx != null) {
            this._state.ctx.lock();
        }
    }

    @Override
    public void unlock() {
        if (this._state.ctx != null) {
            this._state.ctx.unlock();
        }
    }

    @Override
    public int requiresFetch(FieldMetaData fm) {
        if (!this.includes(fm)) {
            return 0;
        }
        Class<?> type = fm.getRelationType();
        if (type == null) {
            return 1;
        }
        if (this._availableDepth == 0) {
            return 0;
        }
        if (this._parent == null) {
            return 1;
        }
        String fieldName = fm.getFullName(false);
        int rdepth = this.getAvailableRecursionDepth(fm, type, fieldName, false);
        if (rdepth != -1 && rdepth <= 0) {
            return 0;
        }
        if (Objects.equals(this._directRelationOwner, fieldName)) {
            return 2;
        }
        return 1;
    }

    @Override
    public boolean requiresLoad() {
        return this._load;
    }

    @Override
    public FetchConfiguration traverse(FieldMetaData fm) {
        Class<?> type = fm.getRelationType();
        if (type == null) {
            return this;
        }
        FetchConfigurationImpl clone = this.newInstance(this._state);
        clone._parent = this;
        clone._availableDepth = FetchConfigurationImpl.reduce(this._availableDepth);
        clone._fromField = fm.getFullName(false);
        clone._fromType = type;
        clone._availableRecursion = this.getAvailableRecursionDepth(fm, type, fm.getFullName(false), true);
        clone._load = Objects.equals(this._directRelationOwner, fm.getFullName(false)) ? false : this._load;
        FieldMetaData owner = fm.getMappedByMetaData();
        if (owner != null && owner.getTypeCode() == 15) {
            clone._directRelationOwner = owner.getFullName(false);
        }
        return clone;
    }

    private boolean includes(FieldMetaData fmd) {
        String[] fgs;
        if (this.hasFetchGroupDefault() && fmd.isInDefaultFetchGroup() || this.hasFetchGroupAll() || this.hasField(fmd.getFullName(false)) || this.hasExtendedLookupPath(fmd)) {
            return true;
        }
        for (String fg : fgs = fmd.getCustomFetchGroups()) {
            if (!this.hasFetchGroup(fg)) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtendedLookupPath(FieldMetaData fmd) {
        return this.getExtendedPathLookup() && (this.hasField(fmd.getRealName()) || this._fromField != null && this.hasField(this._fromField + "." + fmd.getName()));
    }

    private int getAvailableRecursionDepth(FieldMetaData fm, Class<?> type, String fromField, boolean traverse) {
        int avail = Integer.MIN_VALUE;
        FetchConfigurationImpl f = this;
        while (f != null) {
            if (Objects.equals(f._fromField, fromField) && ImplHelper.isAssignable(f._fromType, type)) {
                avail = f._availableRecursion;
                if (!traverse) break;
                avail = FetchConfigurationImpl.reduce(avail);
                break;
            }
            f = f._parent;
        }
        if (avail == 0) {
            return 0;
        }
        ClassMetaData meta = fm.getDefiningMetaData();
        int max = Integer.MIN_VALUE;
        if (fm.isInDefaultFetchGroup()) {
            max = meta.getFetchGroup("default").getRecursionDepth(fm);
        }
        String[] groups = fm.getCustomFetchGroups();
        for (int i = 0; max != -1 && i < groups.length; ++i) {
            int cur;
            if (!this.hasFetchGroup(groups[i]) || (cur = meta.getFetchGroup(groups[i]).getRecursionDepth(fm)) != -1 && cur <= max) continue;
            max = cur;
        }
        if (traverse && max != Integer.MIN_VALUE && ImplHelper.isAssignable(meta.getDescribedType(), type)) {
            max = FetchConfigurationImpl.reduce(max);
        }
        if (avail == Integer.MIN_VALUE && max == Integer.MIN_VALUE) {
            int def = 1;
            return traverse && ImplHelper.isAssignable(meta.getDescribedType(), type) ? def - 1 : def;
        }
        if (avail == Integer.MIN_VALUE || avail == -1) {
            return max;
        }
        if (max == Integer.MIN_VALUE || max == -1) {
            return avail;
        }
        return Math.min(max, avail);
    }

    private static int reduce(int d) {
        if (d == 0) {
            return 0;
        }
        if (d != -1) {
            --d;
        }
        return d;
    }

    FetchConfiguration getParent() {
        return this._parent;
    }

    boolean isRoot() {
        return this._parent == null;
    }

    FetchConfiguration getRoot() {
        return this.isRoot() ? this : this._parent.getRoot();
    }

    int getAvailableFetchDepth() {
        return this._availableDepth;
    }

    int getAvailableRecursionDepth() {
        return this._availableRecursion;
    }

    String getTraversedFromField() {
        return this._fromField;
    }

    Class<?> getTraversedFromType() {
        return this._fromType;
    }

    List<FetchConfigurationImpl> getPath() {
        if (this.isRoot()) {
            return Collections.emptyList();
        }
        return this.trackPath(new ArrayList<FetchConfigurationImpl>());
    }

    List<FetchConfigurationImpl> trackPath(List<FetchConfigurationImpl> path) {
        if (this._parent != null) {
            this._parent.trackPath(path);
        }
        path.add(this);
        return path;
    }

    public String toString() {
        return "FetchConfiguration@" + System.identityHashCode(this) + " (" + this._availableDepth + ")" + this.getPathString();
    }

    private String getPathString() {
        List<FetchConfigurationImpl> path = this.getPath();
        if (path.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder().append(": ");
        Iterator<FetchConfigurationImpl> itr = path.iterator();
        while (itr.hasNext()) {
            buf.append(itr.next().getTraversedFromField());
            if (!itr.hasNext()) continue;
            buf.append("->");
        }
        return buf.toString();
    }

    protected String toString(Object o) {
        return o == null ? "null" : o.toString() + "[" + o.getClass().getName() + "]";
    }

    static {
        String[] prefixes = new String[]{"openjpa.FetchPlan", "openjpa"};
        Class<FetchConfiguration> target = FetchConfiguration.class;
        FetchConfigurationImpl.populateHintSetter(target, "ExtendedPathLookup", Boolean.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "FetchBatchSize", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "FlushBeforeQueries", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "LockScope", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "LockTimeout", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "setLockTimeout", "timeout", Integer.TYPE, "jakarta.persistence.lock");
        FetchConfigurationImpl.populateHintSetter(target, "MaxFetchDepth", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "QueryTimeout", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "setQueryTimeout", "timeout", Integer.TYPE, "jakarta.persistence.query");
        FetchConfigurationImpl.populateHintSetter(target, "ReadLockLevel", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "setReadLockLevel", "ReadLockMode", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "WriteLockLevel", Integer.TYPE, prefixes);
        FetchConfigurationImpl.populateHintSetter(target, "setWriteLockLevel", "WriteLockMode", Integer.TYPE, prefixes);
    }

    protected static class ConfigurationState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public transient StoreContext ctx = null;
        public int fetchBatchSize = 0;
        public int maxFetchDepth = 1;
        public boolean queryCache = true;
        public int flushQuery = 0;
        public int lockTimeout = -1;
        public int queryTimeout = -1;
        public int lockScope = 0;
        public int readLockLevel = 0;
        public int writeLockLevel = 0;
        public Set<String> fetchGroups = null;
        public Set<String> fields = null;
        public Set<Class<?>> rootClasses;
        public Set<Object> rootInstances;
        public Map<String, Object> hints = null;
        public boolean fetchGroupContainsDefault = false;
        public boolean fetchGroupContainsAll = false;
        public boolean fetchGroupIsPUDefault = false;
        public boolean extendedPathLookup = false;
        public DataCacheRetrieveMode cacheRetrieveMode = DataCacheRetrieveMode.USE;
        public DataCacheStoreMode cacheStoreMode = DataCacheStoreMode.USE;
        public boolean cacheNonDefaultFetchPlanQueries = false;

        protected ConfigurationState() {
        }
    }
}

