/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.ConnectionInfo;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.ResultSetResult;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.jdbc.DistributedConnection;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.slice.jdbc.DistributedStoreQuery;
import org.apache.openjpa.slice.jdbc.SliceStoreManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DistributedStoreManager
extends JDBCStoreManager {
    private final List<SliceStoreManager> _slices;
    private JDBCStoreManager _master;
    private final DistributedJDBCConfiguration _conf;
    private static final Localizer _loc = Localizer.forPackage(DistributedStoreManager.class);
    private static ExecutorService threadPool = Executors.newCachedThreadPool();

    public DistributedStoreManager(DistributedJDBCConfiguration conf) {
        this._conf = conf;
        this._slices = new ArrayList<SliceStoreManager>();
        List sliceNames = conf.getActiveSliceNames();
        for (String name : sliceNames) {
            SliceStoreManager slice = new SliceStoreManager(conf.getSlice(name));
            this._slices.add(slice);
            if (!name.equals(conf.getMaster().getName())) continue;
            this._master = slice;
        }
    }

    public DistributedJDBCConfiguration getConfiguration() {
        return this._conf;
    }

    protected String findSliceName(OpenJPAStateManager sm, Object info) {
        boolean hasIndex = this.hasSlice(sm);
        if (hasIndex) {
            return sm.getImplData().toString();
        }
        String slice = this.estimateSlice(sm, info);
        if (slice == null) {
            return this.assignSlice(sm);
        }
        return slice;
    }

    private boolean hasSlice(OpenJPAStateManager sm) {
        return sm.getImplData() != null;
    }

    private String assignSlice(OpenJPAStateManager sm) {
        String slice;
        PersistenceCapable pc = sm.getPersistenceCapable();
        DistributionPolicy policy = this._conf.getDistributionPolicyInstance();
        List sliceNames = this._conf.getActiveSliceNames();
        if (!sliceNames.contains(slice = policy.distribute(pc, sliceNames, this.getContext()))) {
            throw new UserException(_loc.get("bad-policy-slice", new Object[]{policy.getClass().getName(), slice, pc, sliceNames}));
        }
        sm.setImplData((Object)slice, true);
        return slice;
    }

    private String estimateSlice(OpenJPAStateManager sm, Object edata) {
        if (edata == null || !(edata instanceof ConnectionInfo)) {
            return null;
        }
        Result result = ((ConnectionInfo)edata).result;
        if (result instanceof ResultSetResult) {
            JDBCStore store = ((ResultSetResult)result).getStore();
            for (SliceStoreManager slice : this._slices) {
                if (slice != store) continue;
                String sliceId = slice.getName();
                sm.setImplData((Object)sliceId, true);
                return sliceId;
            }
        }
        return null;
    }

    private StoreManager selectStore(OpenJPAStateManager sm, Object edata) {
        String name = this.findSliceName(sm, edata);
        SliceStoreManager slice = this.lookup(name);
        if (slice == null) {
            throw new InternalException(_loc.get("wrong-slice", (Object)name, (Object)sm));
        }
        return slice;
    }

    public boolean assignField(OpenJPAStateManager sm, int field, boolean preFlush) {
        return this.selectStore(sm, null).assignField(sm, field, preFlush);
    }

    public boolean assignObjectId(OpenJPAStateManager sm, boolean preFlush) {
        return this._master.assignObjectId(sm, preFlush);
    }

    public void beforeStateChange(OpenJPAStateManager sm, PCState fromState, PCState toState) {
        this._master.beforeStateChange(sm, fromState, toState);
    }

    public void beginOptimistic() {
        for (SliceStoreManager slice : this._slices) {
            slice.beginOptimistic();
        }
    }

    public boolean cancelAll() {
        boolean ret = true;
        for (SliceStoreManager slice : this._slices) {
            ret = slice.cancelAll() & ret;
        }
        return ret;
    }

    public int compareVersion(OpenJPAStateManager sm, Object v1, Object v2) {
        return this.selectStore(sm, null).compareVersion(sm, v1, v2);
    }

    public Object copyDataStoreId(Object oid, ClassMetaData meta) {
        return this._master.copyDataStoreId(oid, meta);
    }

    public ResultObjectProvider executeExtent(ClassMetaData meta, boolean subclasses, FetchConfiguration fetch) {
        int i = 0;
        List<SliceStoreManager> targets = this.getTargets(fetch);
        ResultObjectProvider[] tmp = new ResultObjectProvider[targets.size()];
        for (SliceStoreManager slice : targets) {
            tmp[i++] = slice.executeExtent(meta, subclasses, fetch);
        }
        return new MergedResultObjectProvider(tmp);
    }

    public boolean exists(OpenJPAStateManager sm, Object edata) {
        for (SliceStoreManager slice : this._slices) {
            if (!slice.exists(sm, edata)) continue;
            sm.setImplData((Object)slice.getName(), true);
            return true;
        }
        return false;
    }

    public Collection flush(Collection sms) {
        ArrayList exceptions = new ArrayList();
        ArrayList<Future<Collection>> futures = new ArrayList<Future<Collection>>();
        Map<String, List<OpenJPAStateManager>> subsets = this.bin(sms, null);
        for (SliceStoreManager sliceStoreManager : this._slices) {
            List<OpenJPAStateManager> subset = subsets.get(sliceStoreManager.getName());
            if (subset.isEmpty()) continue;
            futures.add(threadPool.submit(new Flusher(sliceStoreManager, subset)));
        }
        for (Future future : futures) {
            try {
                Collection error = (Collection)future.get();
                if (error == null || error.isEmpty()) continue;
                exceptions.addAll(error);
            }
            catch (InterruptedException e) {
                throw new StoreException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new StoreException(e.getCause());
            }
        }
        return exceptions;
    }

    private Map<String, List<OpenJPAStateManager>> bin(Collection sms, Object edata) {
        HashMap<String, List<OpenJPAStateManager>> subsets = new HashMap<String, List<OpenJPAStateManager>>();
        for (SliceStoreManager slice : this._slices) {
            subsets.put(slice.getName(), new ArrayList());
        }
        for (SliceStoreManager x : sms) {
            OpenJPAStateManager sm = (OpenJPAStateManager)x;
            String slice = this.findSliceName(sm, edata);
            ((List)subsets.get(slice)).add(sm);
        }
        return subsets;
    }

    public Object getClientConnection() {
        throw new UnsupportedOperationException();
    }

    public Seq getDataStoreIdSequence(ClassMetaData forClass) {
        return this._master.getDataStoreIdSequence(forClass);
    }

    public Class getDataStoreIdType(ClassMetaData meta) {
        return this._master.getDataStoreIdType(meta);
    }

    public Class getManagedType(Object oid) {
        return this._master.getManagedType(oid);
    }

    public Seq getValueSequence(FieldMetaData forField) {
        return this._master.getValueSequence(forField);
    }

    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object edata) {
        String slice;
        if (edata instanceof ConnectionInfo && (slice = this.findSliceName(sm, (ConnectionInfo)edata)) != null) {
            return this.lookup(slice).initialize(sm, state, fetch, edata);
        }
        List<SliceStoreManager> targets = this.getTargets(fetch);
        for (SliceStoreManager slice2 : targets) {
            if (!slice2.initialize(sm, state, fetch, edata)) continue;
            sm.setImplData((Object)slice2.getName(), true);
            return true;
        }
        return false;
    }

    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object edata) {
        return this.selectStore(sm, edata).load(sm, fields, fetch, lockLevel, edata);
    }

    public Collection loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object edata) {
        Map<String, List<OpenJPAStateManager>> subsets = this.bin(sms, edata);
        ArrayList result = new ArrayList();
        for (SliceStoreManager slice : this._slices) {
            Collection tmp;
            List<OpenJPAStateManager> subset = subsets.get(slice.getName());
            if (subset.isEmpty() || (tmp = slice.loadAll(subset, state, load, fetch, edata)) == null || tmp.isEmpty()) continue;
            result.addAll(tmp);
        }
        return result;
    }

    public Object newDataStoreId(Object oidVal, ClassMetaData meta) {
        return this._master.newDataStoreId(oidVal, meta);
    }

    public FetchConfiguration newFetchConfiguration() {
        return this._master.newFetchConfiguration();
    }

    public StoreQuery newQuery(String language) {
        ExpressionParser parser = QueryLanguages.parserForLanguage((String)language);
        DistributedStoreQuery ret = new DistributedStoreQuery((JDBCStore)this, parser);
        for (SliceStoreManager slice : this._slices) {
            ret.add(slice.newQuery(language));
        }
        return ret;
    }

    public void setContext(StoreContext ctx) {
        super.setContext(ctx);
        for (SliceStoreManager store : this._slices) {
            store.setContext(ctx, (JDBCConfiguration)store.getSlice().getConfiguration());
        }
    }

    private SliceStoreManager lookup(String name) {
        for (SliceStoreManager slice : this._slices) {
            if (!slice.getName().equals(name)) continue;
            return slice;
        }
        return null;
    }

    public boolean syncVersion(OpenJPAStateManager sm, Object edata) {
        return this.selectStore(sm, edata).syncVersion(sm, edata);
    }

    protected JDBCStoreManager.RefCountConnection connectInternal() throws SQLException {
        ArrayList<Connection> list = new ArrayList<Connection>();
        for (SliceStoreManager slice : this._slices) {
            list.add(slice.getConnection());
        }
        DistributedConnection con = new DistributedConnection(list);
        return new JDBCStoreManager.RefCountConnection((JDBCStoreManager)this, (Connection)con);
    }

    List<SliceStoreManager> getTargets(FetchConfiguration fetch) {
        if (fetch == null) {
            return this._slices;
        }
        Object hint = fetch.getHint("openjpa.hint.slice.Target");
        if (hint == null || !(hint instanceof String)) {
            return this._slices;
        }
        List<String> targetNames = Arrays.asList(hint.toString().split("\\,"));
        ArrayList<SliceStoreManager> targets = new ArrayList<SliceStoreManager>();
        for (SliceStoreManager slice : this._slices) {
            if (!targetNames.contains(slice.getName())) continue;
            targets.add(slice);
        }
        if (targets.isEmpty()) {
            return this._slices;
        }
        return targets;
    }

    void log(String s) {
        System.out.println("[" + Thread.currentThread().getName() + "] " + (Object)((Object)this) + s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Flusher
    implements Callable<Collection> {
        final SliceStoreManager store;
        final Collection toFlush;

        Flusher(SliceStoreManager store, Collection toFlush) {
            this.store = store;
            this.toFlush = toFlush;
        }

        @Override
        public Collection call() throws Exception {
            return this.store.flush(this.toFlush);
        }
    }
}

