/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;
import org.apache.openjpa.slice.jdbc.DistributedPreparedStatement;
import org.apache.openjpa.slice.jdbc.DistributedStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DistributedConnection
implements Connection {
    static final Constructor<DistributedConnection> concreteImpl;
    private final List<Connection> real;
    private final Connection master;

    public DistributedConnection(List<Connection> connections) {
        if (connections == null || connections.isEmpty()) {
            throw new NullPointerException();
        }
        this.real = connections;
        this.master = connections.get(0);
    }

    public static DistributedConnection newInstance(List<Connection> conns) {
        return (DistributedConnection)ConcreteClassGenerator.newInstance(concreteImpl, (Object[])new Object[]{conns});
    }

    protected abstract void enforceAbstract();

    public boolean contains(Connection c) {
        return this.real.contains(c);
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (Connection c : this.real) {
            c.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        for (Connection c : this.real) {
            c.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        for (Connection c : this.real) {
            c.commit();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        DistributedStatement ret = DistributedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.createStatement());
        }
        return ret;
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        DistributedStatement ret = DistributedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.createStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        DistributedStatement ret = DistributedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.createStatement(arg0, arg1, arg2));
        }
        return ret;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.master.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.master.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.master.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.master.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.master.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.master.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.master.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean ret = true;
        for (Connection c : this.real) {
            ret &= c.isClosed();
        }
        return ret;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean ret = true;
        for (Connection c : this.real) {
            ret &= c.isReadOnly();
        }
        return ret;
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        return this.master.nativeSQL(arg0);
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        if (arg0.startsWith("SELECT SEQUENCE_VALUE FROM OPENJPA_SEQUENCE_TABLE")) {
            return this.master.prepareStatement(arg0);
        }
        DistributedPreparedStatement ret = DistributedPreparedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        DistributedPreparedStatement ret = DistributedPreparedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        DistributedPreparedStatement ret = DistributedPreparedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        DistributedPreparedStatement ret = DistributedPreparedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        DistributedPreparedStatement ret = DistributedPreparedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1, arg2));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        DistributedPreparedStatement ret = DistributedPreparedStatement.newInstance(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1, arg2));
        }
        return ret;
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        for (Connection c : this.real) {
            c.releaseSavepoint(arg0);
        }
    }

    @Override
    public void rollback() throws SQLException {
        for (Connection c : this.real) {
            c.rollback();
        }
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        for (Connection c : this.real) {
            c.rollback(arg0);
        }
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setAutoCommit(arg0);
        }
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setCatalog(arg0);
        }
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setHoldability(arg0);
        }
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setReadOnly(arg0);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setTransactionIsolation(arg0);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setTypeMap(arg0);
        }
    }

    static {
        try {
            concreteImpl = ConcreteClassGenerator.getConcreteConstructor(DistributedConnection.class, (Class[])new Class[]{List.class});
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

