/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import opennlp.model.AbstractEventStream;
import opennlp.model.Event;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerEventStream
extends AbstractEventStream {
    private ChunkerContextGenerator cg;
    private ObjectStream<ChunkSample> data;
    private Event[] events;
    private int ei;

    public ChunkerEventStream(ObjectStream<ChunkSample> d, ChunkerContextGenerator cg) {
        this.cg = cg;
        this.data = d;
        this.ei = 0;
        this.addNewEvents();
    }

    public ChunkerEventStream(ObjectStream<ChunkSample> d) {
        this(d, new DefaultChunkerContextGenerator());
    }

    public Event next() {
        this.hasNext();
        return this.events[this.ei++];
    }

    public boolean hasNext() {
        if (this.ei == this.events.length) {
            this.addNewEvents();
            this.ei = 0;
        }
        return this.ei < this.events.length;
    }

    private void addNewEvents() {
        ChunkSample sample;
        try {
            sample = this.data.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (sample != null) {
            this.events = new Event[sample.getSentence().length];
            String[] toksArray = sample.getSentence();
            String[] tagsArray = sample.getTags();
            String[] predsArray = sample.getPreds();
            int el = this.events.length;
            for (int ei = 0; ei < el; ++ei) {
                this.events[ei] = new Event(predsArray[ei], this.cg.getContext(ei, toksArray, tagsArray, predsArray));
            }
        } else {
            this.events = new Event[0];
        }
    }
}

