/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenizerMEEvaluatorTool
extends AbstractEvaluatorTool<TokenSample, EvalToolParams> {
    public TokenizerMEEvaluatorTool() {
        super(TokenSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "evaluator for the learnable tokenizer";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        TokenizerModel model = (TokenizerModel)new TokenizerModelLoader().load(((EvalToolParams)this.params).getModel());
        TokenEvaluationErrorListener misclassifiedListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            misclassifiedListener = new TokenEvaluationErrorListener();
        }
        TokenizerEvaluator evaluator = new TokenizerEvaluator(new TokenizerME(model), misclassifiedListener);
        System.out.print("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        System.out.println();
        System.out.println(evaluator.getFMeasure());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
    }
}

